/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.ObjectUtils;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SuccessAndMessageResponse {
    private final boolean _success;
    @Nullable
    private final Class<?> _messageClass;
    @Nullable
    private final String _messageKey;
    @Nullable
    private final String[] _messageArgs;

    public SuccessAndMessageResponse(boolean success) {
        this(success, null, null, new String[0]);
    }

    public SuccessAndMessageResponse(boolean success, Class<?> messageClass, String messageKey, String ... messageArgs) {
        this._success = success;
        this._messageClass = messageClass;
        this._messageKey = messageKey;
        this._messageArgs = messageArgs;
    }

    public boolean isSuccess() {
        return this._success;
    }

    public boolean hasMessage() {
        return this._messageClass != null && this._messageKey != null;
    }

    @CheckForNull
    public String getLocalizedMessage(Locale locale) {
        if (this._messageClass == null || this._messageKey == null) {
            return null;
        }
        String msg = Messages.getString(this._messageClass, locale, this._messageKey, this._messageArgs);
        return msg;
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder(this).append("success", this._success).append("messageClass", this._messageClass).append("messageKey", (Object)this._messageKey).toString();
    }
}

