/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.MSWindowsUtils;
import biz.papercut.pcng.client.uit.PrintJobDetailsPanel;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.util.swing.DialogBannerPanel;
import biz.papercut.pcng.util.swing.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BasePrintDialog
extends JDialog {
    protected final UserClientConfig _clientConfig;
    private PrintJobDetailsPanel _printJobDetailsPanel;
    private DialogBannerPanel _dialogBannerPanel;

    protected BasePrintDialog(JFrame owner, UserClientConfig config) {
        super((Frame)owner, true);
        this._clientConfig = config;
    }

    public final void initializeBase(String title, String description, boolean displayBanner, ShowPrintJobOptions showJobOptions) {
        this.setTitle(title);
        DialogUtils.setAlwaysOnTop((Window)this, (boolean)true);
        this.toFront();
        this._printJobDetailsPanel = new PrintJobDetailsPanel();
        this._dialogBannerPanel = UserClientUtils.getStandardDialogBanner(title, description, this._clientConfig.getServerGlobalConfig());
        this.layoutDialog(displayBanner, showJobOptions);
        JButton defaultButton = this.getDefaultButton();
        if (defaultButton != null) {
            this.getRootPane().setDefaultButton(defaultButton);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (BasePrintDialog.this.handleWindowClosing(e)) {
                    BasePrintDialog.this.setVisible(false);
                }
            }
        });
        this.doLayout();
        this.pack();
        final Dimension minSize = this.calculateMinSize((int)this.getSize().getWidth(), (int)this.getSize().getHeight());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                BasePrintDialog.this.setSize(Math.max((int)minSize.getWidth(), BasePrintDialog.this.getWidth()), Math.max((int)minSize.getHeight(), BasePrintDialog.this.getHeight()));
            }
        });
        Dimension initialSize = this.calculateInitialSize((int)minSize.getWidth(), (int)minSize.getHeight());
        this.setSize(initialSize);
        this.setLocationRelativeTo(null);
        MSWindowsUtils.addWindowListenerToBringWindowToFrontOnOpen(this);
        DialogUtils.forceRepaintAfterOpened((Window)this);
    }

    public void displayJobDetails(ClientPrintJob job) {
        this._printJobDetailsPanel.displayJobDetails(job);
    }

    protected boolean handleWindowClosing(WindowEvent e) {
        return false;
    }

    private void layoutDialog(boolean displayBanner, ShowPrintJobOptions showJobOptions) {
        JPanel mainPanel = this.constructMainPanel();
        JPanel buttonPanel = this.constructButtonPanel();
        JPanel inner = new JPanel(new BorderLayout());
        if (showJobOptions == ShowPrintJobOptions.ShowBasicOnly) {
            this._printJobDetailsPanel.removePagesAndCostDetails();
        }
        if (showJobOptions != ShowPrintJobOptions.ShowNone) {
            inner.add((Component)this._printJobDetailsPanel, "North");
        }
        inner.add((Component)mainPanel, "Center");
        if (buttonPanel != null) {
            inner.add((Component)buttonPanel, "South");
        }
        if (displayBanner) {
            JPanel contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)this._dialogBannerPanel, "North");
            contentPanel.add((Component)inner, "Center");
            this.setContentPane(contentPanel);
        } else {
            this.setContentPane(inner);
        }
    }

    protected Dimension calculateInitialSize(int minWidth, int minHeight) {
        return new Dimension(minWidth, minHeight);
    }

    protected Dimension calculateMinSize(int width, int height) {
        return new Dimension(width, height);
    }

    protected JPanel constructMainPanel() {
        return new JPanel();
    }

    protected JPanel constructButtonPanel() {
        return null;
    }

    protected JButton getDefaultButton() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShowPrintJobOptions {
        ShowNone,
        ShowAll,
        ShowBasicOnly;

    }
}

