/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.windows;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.windows.WindowsBrowserLaunching;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.wraplog.AbstractLogger;

abstract class DefaultWindowsBrowserLaunching
extends WindowsBrowserLaunching {
    private static final Map protocolToCommandsArg;
    private final String browserCmmnd;
    private final List browserList = new ArrayList();
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String THIRD_WINDOWS_PARAMETER = "\"\"";

    protected DefaultWindowsBrowserLaunching(String browserCmmnd, AbstractLogger logger) {
        super(logger);
        this.browserCmmnd = browserCmmnd;
        this.browserList.add("Default");
        this.browserList.add("firefox");
        this.browserList.add("iexplore");
        this.browserList.add("mozilla");
    }

    public void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            this.logger.info(urlString);
            String protocol = this.getProtocol(urlString);
            this.logger.info(protocol);
            CommandArgs cmmndArgs = (CommandArgs)protocolToCommandsArg.get(protocol);
            if (cmmndArgs == null) {
                cmmndArgs = (CommandArgs)protocolToCommandsArg.get(null);
            }
            String[] args = cmmndArgs.getArgs(this.browserCmmnd, urlString);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.getArrayAsString(args));
            }
            Process process = Runtime.getRuntime().exec(args);
            process.waitFor();
            process.exitValue();
        }
        catch (Exception e) {
            this.logger.error("fatal exception", e);
            throw new BrowserLaunchingExecutionException(e);
        }
    }

    public void openUrl(String browser, String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        if ("Default".equals(browser) || browser == null) {
            this.logger.info("default or null browser target");
            this.openUrl(urlString);
        } else {
            boolean successfullLaunch = false;
            try {
                this.logger.info(urlString);
                String protocol = this.getProtocol(urlString);
                this.logger.info(protocol);
                CommandArgs cmmndArgs = (CommandArgs)protocolToCommandsArg.get(protocol);
                if (cmmndArgs == null) {
                    cmmndArgs = (CommandArgs)protocolToCommandsArg.get(null);
                }
                String[] args = cmmndArgs.getArgs(this.browserCmmnd, browser, urlString);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.getArrayAsString(args));
                }
                Process process = Runtime.getRuntime().exec(args);
                process.waitFor();
                successfullLaunch = process.exitValue() == 0;
            }
            catch (Exception e) {
                this.logger.error("fatal exception", e);
                successfullLaunch = false;
            }
            if (!successfullLaunch) {
                this.logger.debug("falling through to non-targetted openUrl");
                this.openUrl(urlString);
            }
        }
    }

    public List getBrowserList() {
        return this.browserList;
    }

    static {
        HashMap<String, CommandArgs> tempMap = new HashMap<String, CommandArgs>();
        StandardCommandArgs stndrdArgs = new StandardCommandArgs();
        tempMap.put(null, stndrdArgs);
        tempMap.put("http", stndrdArgs);
        tempMap.put("mailto", stndrdArgs);
        tempMap.put("file", new FileCommandArgs());
        protocolToCommandsArg = Collections.unmodifiableMap(tempMap);
    }

    private static final class FileCommandArgs
    extends CommandArgs {
        private FileCommandArgs() {
        }

        String[] getArgs(String browserCmmnd, String urlString) {
            return new String[]{browserCmmnd, DefaultWindowsBrowserLaunching.FIRST_WINDOWS_PARAMETER, DefaultWindowsBrowserLaunching.SECOND_WINDOWS_PARAMETER, DefaultWindowsBrowserLaunching.THIRD_WINDOWS_PARAMETER, '\"' + urlString + '\"'};
        }

        String[] getArgs(String browserCmmnd, String browserName, String urlString) {
            return new String[]{browserCmmnd, DefaultWindowsBrowserLaunching.FIRST_WINDOWS_PARAMETER, DefaultWindowsBrowserLaunching.SECOND_WINDOWS_PARAMETER, browserName, '\"' + urlString + '\"'};
        }
    }

    private static final class StandardCommandArgs
    extends CommandArgs {
        private StandardCommandArgs() {
        }

        String[] getArgs(String browserCmmnd, String urlString) {
            return new String[]{browserCmmnd, DefaultWindowsBrowserLaunching.FIRST_WINDOWS_PARAMETER, DefaultWindowsBrowserLaunching.SECOND_WINDOWS_PARAMETER, DefaultWindowsBrowserLaunching.THIRD_WINDOWS_PARAMETER, '\"' + urlString + '\"'};
        }

        String[] getArgs(String browserCmmnd, String browserName, String urlString) {
            return new String[]{browserCmmnd, DefaultWindowsBrowserLaunching.FIRST_WINDOWS_PARAMETER, DefaultWindowsBrowserLaunching.SECOND_WINDOWS_PARAMETER, browserName, '\"' + urlString + '\"'};
        }
    }

    private static abstract class CommandArgs {
        private CommandArgs() {
        }

        abstract String[] getArgs(String var1, String var2);

        abstract String[] getArgs(String var1, String var2, String var3);
    }
}

