/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.util.swing.DialogBannerPanel;
import java.awt.Image;
import java.io.File;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class UserClientUtils {
    private static final Log logger = LogFactory.getLog(UserClientUtils.class);
    private static final String PROP_CLIENT_HOME = "client.home";
    private static final String CUSTOM_IMAGE_NAME = "client-logo.png";
    private static boolean _hasCheckedForCustomImage = false;
    private static File _customImageFile = null;

    private UserClientUtils() {
    }

    public static String getHomeDirectory() {
        String home = System.getProperty(PROP_CLIENT_HOME);
        if (home != null) {
            File homeDir = new File(home);
            logger.debug((Object)("Testing home directory: " + home));
            if (homeDir.exists() && homeDir.isDirectory()) {
                home = homeDir.getAbsolutePath();
            } else {
                logger.warn((Object)"Specified client.home does not exist, using current dir.");
                home = new File("").getAbsolutePath();
            }
        }
        if (home == null) {
            logger.debug((Object)"client.home null, using current directory as home directory");
            home = new File("").getAbsolutePath();
        }
        logger.debug((Object)("Using home directory: " + home));
        return home;
    }

    public static File getCustomIconImage() {
        if (!_hasCheckedForCustomImage) {
            logger.debug((Object)"Checking for custom icon image");
            try {
                File f = new File(UserClientUtils.getHomeDirectory(), CUSTOM_IMAGE_NAME);
                if (f.exists()) {
                    _customImageFile = f;
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Unable to locate custom icon", (Throwable)e);
            }
            _hasCheckedForCustomImage = true;
        }
        return _customImageFile;
    }

    public static DialogBannerPanel getStandardDialogBanner(String title, String description, ClientGlobalConfigFromServer conf) {
        Image scaledImage;
        ImageIcon orig;
        ImageIcon icon = null;
        File customIcon = UserClientUtils.getCustomIconImage();
        if (customIcon != null) {
            try {
                orig = new ImageIcon(customIcon.getAbsolutePath());
                scaledImage = orig.getImage().getScaledInstance(48, 48, 4);
                icon = new ImageIcon(scaledImage);
            }
            catch (Exception e) {
                logger.debug((Object)("Unable to load custom icon: " + e.getMessage()));
            }
        }
        if (icon == null) {
            orig = new ImageIcon(UserClientUtils.class.getResource("images/client-icon-64.png"));
            scaledImage = orig.getImage().getScaledInstance(48, 48, 4);
            icon = new ImageIcon(scaledImage);
        }
        DialogBannerPanel panel = new DialogBannerPanel(title, description, icon, conf.isShowLink(), conf.getLinkURL(), conf.getLinkText());
        return panel;
    }
}

