/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing.flash;

import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.SwingUtils;
import biz.papercut.pcng.util.swing.flash.FlashContent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;

public class FlashPasswordInput
extends JPanel
implements FlashContent {
    private final JPasswordField _passwordField;
    private final SubmitListener _submitListener;
    private final ActionListener _activityListener;
    private final MouseListener _mouseListener;
    private volatile FlashContent.FlashContentEventHandler _eventHandler;

    public FlashPasswordInput(Builder builder) {
        String title = StringUtils.trimToNull((String)builder._title);
        String text = StringUtils.trimToEmpty((String)builder._text).replace("\n", "<br />");
        this._submitListener = builder._submitListener;
        this._activityListener = builder._activityListener;
        this._mouseListener = builder._mouseListener;
        MouseListener mouseListener = new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (FlashPasswordInput.this._mouseListener != null) {
                    FlashPasswordInput.this._mouseListener.mouseClicked(e);
                }
            }

            public void mousePressed(MouseEvent e) {
                if (FlashPasswordInput.this._mouseListener != null) {
                    FlashPasswordInput.this._mouseListener.mousePressed(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (FlashPasswordInput.this._mouseListener != null) {
                    FlashPasswordInput.this._mouseListener.mouseReleased(e);
                }
            }

            public void mouseEntered(MouseEvent e) {
                if (FlashPasswordInput.this._mouseListener != null) {
                    FlashPasswordInput.this._mouseListener.mouseEntered(e);
                }
            }

            public void mouseExited(MouseEvent e) {
                if (FlashPasswordInput.this._mouseListener != null) {
                    FlashPasswordInput.this._mouseListener.mouseExited(e);
                }
            }
        };
        ActionListener submitActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FlashPasswordInput.this._submitListener.submitPerformed(FlashPasswordInput.this.getPassword());
                FlashPasswordInput.this._eventHandler.hide();
            }
        };
        ActionListener dismissActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (FlashPasswordInput.this._eventHandler != null) {
                    FlashPasswordInput.this._eventHandler.dismiss();
                }
            }
        };
        int pad = 10;
        this.setLayout(new BorderLayout(pad, pad));
        this.setOpaque(true);
        this.setBackground(builder._background);
        this.setForeground(builder._foreground);
        this.setBorder(BorderFactory.createLineBorder(builder._foreground, 2));
        if (title != null) {
            JPanel titlePanel = new JPanel(new BorderLayout());
            titlePanel.setBackground(builder._background);
            titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, builder._foreground), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            JLabel titleLabel = new JLabel(title);
            titleLabel.setForeground(builder._foreground);
            titlePanel.add((Component)titleLabel, "West");
            this.add((Component)titlePanel, "North");
        }
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(pad, pad));
        contentPanel.setBackground(builder._background);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(pad, pad, pad, pad));
        JLabel textLabel = new JLabel("<html><center>" + text + "</center></html>");
        textLabel.setForeground(builder._foreground);
        textLabel.setFont(new Font(textLabel.getFont().getName(), 0, textLabel.getFont().getSize()));
        contentPanel.add((Component)textLabel, "North");
        this._passwordField = new JPasswordField(10);
        this._passwordField.addActionListener(submitActionListener);
        this._passwordField.addMouseListener(mouseListener);
        this._passwordField.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                FlashPasswordInput.this.activityOccurred();
            }

            public void insertUpdate(DocumentEvent e) {
                FlashPasswordInput.this.activityOccurred();
            }

            public void changedUpdate(DocumentEvent e) {
                FlashPasswordInput.this.activityOccurred();
            }
        });
        contentPanel.add((Component)this._passwordField, "Center");
        if (builder._label != null) {
            JLabel inputLabel = new JLabel(builder._label);
            inputLabel.setForeground(builder._foreground);
            inputLabel.setLabelFor(this._passwordField);
            contentPanel.add((Component)inputLabel, "West");
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setOpaque(false);
        JButton okButton = new JButton(Messages.getString(this.getClass(), "FlashPasswordInput.ok", new String[0]));
        SwingUtils.setOpaqueIfRequired(okButton);
        okButton.addActionListener(submitActionListener);
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Messages.getString(this.getClass(), "FlashPasswordInput.cancel", new String[0]));
        SwingUtils.setOpaqueIfRequired(cancelButton);
        cancelButton.addActionListener(dismissActionListener);
        buttonPanel.add(cancelButton);
        contentPanel.add((Component)buttonPanel, "South");
        this.add((Component)contentPanel, "Center");
    }

    public String getPassword() {
        String input = new String(this._passwordField.getPassword());
        String password = StringUtils.trimToNull((String)input);
        return password;
    }

    public Component getComponent() {
        return this;
    }

    public void setEventHandler(FlashContent.FlashContentEventHandler eventHandler) {
        this._eventHandler = eventHandler;
    }

    public void showing() {
        this._passwordField.requestFocus();
    }

    protected void activityOccurred() {
        if (this._eventHandler != null) {
            this._eventHandler.activityOccurred();
        }
        if (this._activityListener != null) {
            this._activityListener.actionPerformed(new ActionEvent(this, 0, "KEY_TYPED"));
        }
    }

    public static interface SubmitListener {
        public void submitPerformed(String var1);
    }

    public static class Builder {
        private String _title;
        private String _text;
        private String _label;
        private Color _background;
        private Color _foreground;
        private SubmitListener _submitListener;
        private ActionListener _activityListener;
        private MouseListener _mouseListener;

        public Builder title(String title) {
            this._title = title;
            return this;
        }

        public Builder text(String text) {
            this._text = text;
            return this;
        }

        public Builder background(Color background) {
            this._background = background;
            return this;
        }

        public Builder foreground(Color foreground) {
            this._foreground = foreground;
            return this;
        }

        public Builder label(String label) {
            this._label = label;
            return this;
        }

        public Builder mouseActivityListener(MouseListener mouseListener) {
            this._mouseListener = mouseListener;
            return this;
        }

        public Builder submitListener(SubmitListener submitListener) {
            this._submitListener = submitListener;
            return this;
        }

        public Builder activityListener(ActionListener activityListener) {
            this._activityListener = activityListener;
            return this;
        }

        public FlashPasswordInput build() {
            if (this._background == null) {
                throw new IllegalStateException("background color is required");
            }
            if (this._foreground == null) {
                throw new IllegalStateException("foreground color is required");
            }
            if (this._submitListener == null) {
                throw new IllegalStateException("submit listener is required");
            }
            return new FlashPasswordInput(this);
        }
    }
}

