/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwingWorker<T> {
    private T _value;
    private ThreadVar _threadVar;

    protected synchronized T getValue() {
        return this._value;
    }

    private synchronized void setValue(T x) {
        this._value = x;
    }

    public abstract T construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t = this._threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this._threadVar.clear();
    }

    public T get() {
        Thread t;
        while ((t = this._threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this._threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct);
        this._threadVar = new ThreadVar(t);
    }

    public void start() {
        Thread t = this._threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    public void join() throws InterruptedException {
        this._threadVar.get().join();
    }

    private static class ThreadVar {
        private Thread _thread;

        ThreadVar(Thread t) {
            this._thread = t;
        }

        synchronized Thread get() {
            return this._thread;
        }

        synchronized void clear() {
            this._thread = null;
        }
    }
}

