/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.lang.reflect.Method;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.StandardToStringStyle;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.enums.Enum;
import org.apache.commons.lang.time.DateFormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectUtils {
    public static final StandardToStringStyle TO_STRING_STYLE = new StandardToStringStyle(){

        protected void appendDetail(StringBuffer buffer, String fieldName, boolean value) {
            this.appendDetail(buffer, fieldName, value ? (char)'Y' : 'N');
        }

        protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
            if (value instanceof Date) {
                super.appendDetail(buffer, fieldName, (Object)DateFormatUtils.ISO_DATETIME_FORMAT.format((Date)value));
            } else if (value instanceof Enum) {
                super.appendDetail(buffer, fieldName, (Object)((Enum)value).getName());
            } else {
                super.appendDetail(buffer, fieldName, value);
            }
        }

        protected String getShortClassName(Class cls) {
            if (cls == null) {
                return "";
            }
            String s = cls.getName();
            int index = s.lastIndexOf(46);
            if (index >= 0) {
                s = s.substring(index + 1);
            }
            if ((index = s.lastIndexOf(36)) >= 0) {
                s = s.substring(index + 1);
            }
            return s;
        }
    };

    private ObjectUtils() {
    }

    public static ToStringBuilder createToStringBuilder(Object object) {
        return new ToStringBuilder(object, (ToStringStyle)TO_STRING_STYLE);
    }

    public static Object invokeMethod(Object target, String methodName, Object[] args) {
        Method method;
        block9: {
            if (target == null) {
                throw new IllegalArgumentException("Target object is required");
            }
            if (methodName == null) {
                throw new IllegalArgumentException("Target method is required");
            }
            if (args == null) {
                args = new Object[]{};
            }
            Class<?> targetClass = target.getClass();
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = args[i] != null ? args[i].getClass() : Object.class;
            }
            try {
                method = targetClass.getMethod(methodName, argTypes);
            }
            catch (NoSuchMethodException ex) {
                method = ObjectUtils.findMatchingMethod(targetClass, methodName, args);
                if (method != null) break block9;
                throw new RuntimeException("Cannot find a matching method: " + methodName, ex);
            }
        }
        try {
            return method.invoke(target, args);
        }
        catch (Exception e) {
            String errMsg = "";
            Throwable cause = e;
            while (cause != null && StringUtils.isBlank((String)errMsg)) {
                cause = e.getCause();
                if (cause == null) continue;
                errMsg = StringUtils.trimToEmpty((String)cause.getMessage());
            }
            throw new RuntimeException("Unable to run method: " + methodName + ", error: " + errMsg, e);
        }
    }

    protected static Method findMatchingMethod(Class<? extends Object> clazz, String method, Object[] args) {
        Method[] candidates = clazz.getMethods();
        int argCount = args.length;
        Method matchingMethod = null;
        int numberOfMatchingMethods = 0;
        for (int i = 0; i < candidates.length; ++i) {
            if (!candidates[i].getName().equals(method) || candidates[i].getParameterTypes().length != argCount) continue;
            matchingMethod = candidates[i];
            ++numberOfMatchingMethods;
        }
        if (numberOfMatchingMethods == 1) {
            return matchingMethod;
        }
        return null;
    }

    static {
        TO_STRING_STYLE.setUseShortClassName(true);
        TO_STRING_STYLE.setUseIdentityHashCode(false);
    }
}

