/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

import biz.papercut.pcng.common.AccountCommentOption;
import biz.papercut.pcng.common.AccountInvoiceOption;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientAccount {
    private static final String SUB_ACCOUNT_SEPARATOR = "\\";
    public static final int CURRENT_SERIALIZED_FORMAT = 3;
    private long _accountId;
    private String _parentName = "";
    private String _subName = "";
    private String _parentPin = "";
    private String _subPin = "";
    private AccountCommentOption _comments = AccountCommentOption.COMMENT_OPTIONAL;
    private AccountInvoiceOption _invoicing = AccountInvoiceOption.USER_CHOICE_ON;
    private boolean _disabled = false;

    public ClientAccount(long accountId) {
        this.setAccountId(accountId);
    }

    public static ClientAccount loadFromVector(Vector<Object> data, int accountFormat) {
        if (accountFormat != 3) {
            throw new IllegalArgumentException("Only support reading accounts in format: 3");
        }
        ClientAccount acct = new ClientAccount(Long.valueOf((String)data.get(0)));
        acct.setParentName((String)data.get(1));
        acct.setSubName((String)data.get(2));
        acct.setParentPin((String)data.get(3));
        acct.setSubPin((String)data.get(4));
        acct.setDisabled((Boolean)data.get(5));
        int commentIndex = (Integer)data.get(6);
        acct.setComments(AccountCommentOption.getEnum(commentIndex));
        int invoiceIndex = (Integer)data.get(7);
        acct.setInvoicing(AccountInvoiceOption.getEnum(invoiceIndex));
        return acct;
    }

    private Vector<Object> saveToVectorFormat3() {
        Vector<Object> data = new Vector<Object>(8);
        data.add(String.valueOf(this.getAccountId()));
        data.add(this.getParentName());
        data.add(this.getSubName());
        data.add(this.getParentPin());
        data.add(this.getSubPin());
        data.add(this.isDisabled());
        data.add(this.getComments().getIndex());
        data.add(this.getInvoicing().getIndex());
        return data;
    }

    private Vector<Object> saveToVectorFormat2() {
        Vector<Object> data = new Vector<Object>(9);
        data.add(String.valueOf(this.getAccountId()));
        data.add("");
        data.add(this.getParentName());
        data.add(this.getSubName());
        data.add(this.getParentPin());
        data.add(this.isDisabled());
        data.add(this.getComments().getIndex());
        data.add(this.getInvoicing().getIndex());
        data.add(this.getSubPin());
        return data;
    }

    private Vector<Object> saveToVectorFormat1() {
        Vector<Object> data = new Vector<Object>(2);
        data.add(String.valueOf(this.getAccountId()));
        data.add(this.getDisplayName());
        return data;
    }

    public Vector<Object> saveToVector(int format) {
        switch (format) {
            case 1: {
                return this.saveToVectorFormat1();
            }
            case 2: {
                return this.saveToVectorFormat2();
            }
            case 3: {
                return this.saveToVectorFormat3();
            }
        }
        throw new IllegalArgumentException("Unknown client account vector format: " + format);
    }

    public long getAccountId() {
        return this._accountId;
    }

    public void setAccountId(long accountId) {
        this._accountId = accountId;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public String getSubName() {
        return this._subName;
    }

    public void setSubName(String childName) {
        this._subName = childName;
    }

    public String getParentPin() {
        return this._parentPin;
    }

    public void setParentPin(String pin) {
        this._parentPin = pin;
    }

    public String getSubPin() {
        return this._subPin;
    }

    public void setSubPin(String subPin) {
        this._subPin = subPin;
    }

    public String getFullPin() {
        String pin = "";
        if (this.isParent()) {
            pin = this.getParentPin();
        } else if (StringUtils.isNotBlank((String)this.getSubPin())) {
            pin = StringUtils.isNotBlank((String)this.getParentPin()) ? this.getParentPin() + "-" + this.getSubPin() : this.getSubPin();
        }
        return StringUtils.trimToEmpty((String)pin);
    }

    public AccountCommentOption getComments() {
        return this._comments;
    }

    public void setComments(AccountCommentOption comments) {
        this._comments = comments;
    }

    public AccountInvoiceOption getInvoicing() {
        return this._invoicing;
    }

    public void setInvoicing(AccountInvoiceOption invoicing) {
        this._invoicing = invoicing;
    }

    public String getParentName() {
        return this._parentName;
    }

    public void setParentName(String parentName) {
        this._parentName = parentName;
    }

    public boolean isParent() {
        return StringUtils.isEmpty((String)this.getSubName());
    }

    public String getDisplayName() {
        if (StringUtils.isBlank((String)this.getSubName())) {
            return this.getParentName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getParentName());
        sb.append(SUB_ACCOUNT_SEPARATOR);
        sb.append(this.getSubName());
        return sb.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }
}

