/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.Header;
import com.sun.jndi.dns.Packet;
import com.sun.jndi.dns.ResourceRecords;
import com.sun.jndi.dns.Tcp;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;

public class DnsClient {
    private static final int IDENT_OFFSET = 0;
    private static final int FLAGS_OFFSET = 2;
    private static final int NUMQ_OFFSET = 4;
    private static final int NUMANS_OFFSET = 6;
    private static final int NUMAUTH_OFFSET = 8;
    private static final int NUMADD_OFFSET = 10;
    private static final int DNS_HDR_SIZE = 12;
    private static final int NO_ERROR = 0;
    private static final int FORMAT_ERROR = 1;
    private static final int SERVER_FAILURE = 2;
    private static final int NAME_ERROR = 3;
    private static final int NOT_IMPL = 4;
    private static final int REFUSED = 5;
    private static final String[] rcodeDescription = new String[]{"No error", "DNS format error", "DNS server failure", "DNS name not found", "DNS operation not supported", "DNS service refused"};
    private static final int DEFAULT_PORT = 53;
    private InetAddress[] servers;
    private int[] serverPorts;
    private int timeout;
    private int retries;
    private DatagramSocket udpSocket;
    private Set<Integer> reqs;
    private Map<Integer, byte[]> resps;
    private Object queuesLock = new Object();
    private int ident = 0;
    private Object identLock = new Object();
    private static boolean debug = false;

    public DnsClient(String[] stringArray, int n, int n2) throws NamingException {
        this.timeout = n;
        this.retries = n2;
        try {
            this.udpSocket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            ConfigurationException configurationException = new ConfigurationException();
            configurationException.setRootCause(socketException);
            throw configurationException;
        }
        this.servers = new InetAddress[stringArray.length];
        this.serverPorts = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = stringArray[i].indexOf(58, stringArray[i].indexOf(93) + 1);
            this.serverPorts[i] = n3 < 0 ? 53 : Integer.parseInt(stringArray[i].substring(n3 + 1));
            String string = n3 < 0 ? stringArray[i] : stringArray[i].substring(0, n3);
            try {
                this.servers[i] = InetAddress.getByName(string);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                ConfigurationException configurationException = new ConfigurationException("Unknown DNS server: " + string);
                configurationException.setRootCause(unknownHostException);
                throw configurationException;
            }
        }
        this.reqs = Collections.synchronizedSet(new HashSet());
        this.resps = Collections.synchronizedMap(new HashMap());
    }

    protected void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.udpSocket.close();
        Object object = this.queuesLock;
        synchronized (object) {
            this.reqs.clear();
            this.resps.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords query(DnsName dnsName, int n, int n2, boolean bl, boolean bl2) throws NamingException {
        int n3;
        Object object = this.identLock;
        synchronized (object) {
            n3 = this.ident = 0xFFFF & this.ident + 1;
        }
        this.reqs.add(n3);
        object = this.makeQueryPacket(dnsName, n3, n, n2, bl);
        Exception exception = null;
        boolean[] blArray = new boolean[this.servers.length];
        for (int i = 0; i < this.retries; ++i) {
            for (int j = 0; j < this.servers.length; ++j) {
                if (blArray[j]) continue;
                try {
                    if (debug) {
                        DnsClient.dprint("SEND ID (" + (i + 1) + "): " + n3);
                    }
                    byte[] byArray = null;
                    byArray = this.doUdpQuery((Packet)object, this.servers[j], this.serverPorts[j], i, n3);
                    if (byArray == null) {
                        if (this.resps.size() > 0) {
                            byArray = this.lookupResponse(n3);
                        }
                        if (byArray == null) continue;
                    }
                    Header header = new Header(byArray, byArray.length);
                    if (bl2 && !header.authoritative) {
                        exception = new NameNotFoundException("DNS response not authoritative");
                        blArray[j] = true;
                        continue;
                    }
                    if (header.truncated) {
                        for (int k = 0; k < this.servers.length; ++k) {
                            int n4 = (j + k) % this.servers.length;
                            if (blArray[n4]) continue;
                            try {
                                byte[] byArray2;
                                Tcp tcp = new Tcp(this.servers[n4], this.serverPorts[n4]);
                                try {
                                    byArray2 = this.doTcpQuery(tcp, (Packet)object);
                                }
                                finally {
                                    tcp.close();
                                }
                                Header header2 = new Header(byArray2, byArray2.length);
                                if (header2.query) {
                                    throw new CommunicationException("DNS error: expecting response");
                                }
                                this.checkResponseCode(header2);
                                if (!bl2 || header2.authoritative) {
                                    header = header2;
                                    byArray = byArray2;
                                    break;
                                }
                                blArray[n4] = true;
                                continue;
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                    }
                    return new ResourceRecords(byArray, byArray.length, header, false);
                }
                catch (IOException iOException) {
                    if (debug) {
                        DnsClient.dprint("Caught IOException:" + iOException);
                    }
                    if (exception == null) {
                        exception = iOException;
                    }
                    if (!iOException.getClass().getName().equals("java.net.PortUnreachableException")) continue;
                    blArray[j] = true;
                    continue;
                }
                catch (NameNotFoundException nameNotFoundException) {
                    throw nameNotFoundException;
                }
                catch (CommunicationException communicationException) {
                    if (exception != null) continue;
                    exception = communicationException;
                    continue;
                }
                catch (NamingException namingException) {
                    if (exception == null) {
                        exception = namingException;
                    }
                    blArray[j] = true;
                }
            }
        }
        this.reqs.remove(n3);
        if (exception instanceof NamingException) {
            throw (NamingException)exception;
        }
        CommunicationException communicationException = new CommunicationException("DNS error");
        communicationException.setRootCause(exception);
        throw communicationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords queryZone(DnsName dnsName, int n, boolean bl) throws NamingException {
        int n2;
        Object object = this.identLock;
        synchronized (object) {
            n2 = this.ident = 0xFFFF & this.ident + 1;
        }
        object = this.makeQueryPacket(dnsName, n2, n, 252, bl);
        Exception exception = null;
        for (int i = 0; i < this.servers.length; ++i) {
            ResourceRecords resourceRecords;
            Tcp tcp = new Tcp(this.servers[i], this.serverPorts[i]);
            try {
                byte[] byArray = this.doTcpQuery(tcp, (Packet)object);
                Header header = new Header(byArray, byArray.length);
                this.checkResponseCode(header);
                ResourceRecords resourceRecords2 = new ResourceRecords(byArray, byArray.length, header, true);
                if (resourceRecords2.getFirstAnsType() != 6) {
                    throw new CommunicationException("DNS error: zone xfer doesn't begin with SOA");
                }
                if (resourceRecords2.answer.size() == 1 || resourceRecords2.getLastAnsType() != 6) {
                    do {
                        if ((byArray = this.continueTcpQuery(tcp)) == null) {
                            throw new CommunicationException("DNS error: incomplete zone transfer");
                        }
                        header = new Header(byArray, byArray.length);
                        this.checkResponseCode(header);
                        resourceRecords2.add(byArray, byArray.length, header);
                    } while (resourceRecords2.getLastAnsType() != 6);
                }
                resourceRecords2.answer.removeElementAt(resourceRecords2.answer.size() - 1);
                resourceRecords = resourceRecords2;
            }
            catch (Throwable throwable) {
                try {
                    tcp.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    exception = iOException;
                    continue;
                }
                catch (NameNotFoundException nameNotFoundException) {
                    throw nameNotFoundException;
                }
                catch (NamingException namingException) {
                    exception = namingException;
                }
            }
            tcp.close();
            return resourceRecords;
        }
        if (exception instanceof NamingException) {
            throw (NamingException)exception;
        }
        CommunicationException communicationException = new CommunicationException("DNS error during zone transfer");
        communicationException.setRootCause(exception);
        throw communicationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] doUdpQuery(Packet packet, InetAddress inetAddress, int n, int n2, int n3) throws IOException, NamingException {
        int n4 = 50;
        DatagramSocket datagramSocket = this.udpSocket;
        synchronized (datagramSocket) {
            DatagramPacket datagramPacket = new DatagramPacket(packet.getData(), packet.length(), inetAddress, n);
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[8000], 8000);
            this.udpSocket.connect(inetAddress, n);
            int n5 = this.timeout * (1 << n2);
            try {
                long l;
                long l2;
                this.udpSocket.send(datagramPacket);
                int n6 = n5;
                int n7 = 0;
                do {
                    if (debug) {
                        DnsClient.dprint("Trying RECEIVE(" + ++n7 + ") retry(" + (n2 + 1) + ") for:" + n3 + "    sock-timeout:" + n6 + " ms.");
                    }
                    this.udpSocket.setSoTimeout(n6);
                    l = System.currentTimeMillis();
                    this.udpSocket.receive(datagramPacket2);
                    l2 = System.currentTimeMillis();
                    byte[] byArray = new byte[datagramPacket2.getLength()];
                    byArray = datagramPacket2.getData();
                    if (!this.isMatchResponse(byArray, n3)) continue;
                    byte[] byArray2 = byArray;
                    return byArray2;
                } while ((n6 = n5 - (int)(l2 - l)) > n4);
            }
            finally {
                this.udpSocket.disconnect();
            }
            return null;
        }
    }

    private byte[] doTcpQuery(Tcp tcp, Packet packet) throws IOException {
        int n = packet.length();
        tcp.out.write(n >> 8);
        tcp.out.write(n);
        tcp.out.write(packet.getData(), 0, n);
        tcp.out.flush();
        byte[] byArray = this.continueTcpQuery(tcp);
        if (byArray == null) {
            throw new IOException("DNS error: no response");
        }
        return byArray;
    }

    private byte[] continueTcpQuery(Tcp tcp) throws IOException {
        int n = tcp.in.read();
        if (n == -1) {
            return null;
        }
        int n2 = tcp.in.read();
        if (n2 == -1) {
            throw new IOException("Corrupted DNS response: bad length");
        }
        int n3 = n << 8 | n2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        while (n3 > 0) {
            int n5 = tcp.in.read(byArray, n4, n3);
            if (n5 == -1) {
                throw new IOException("Corrupted DNS response: too little data");
            }
            n3 -= n5;
            n4 += n5;
        }
        return byArray;
    }

    private Packet makeQueryPacket(DnsName dnsName, int n, int n2, int n3, boolean bl) {
        short s = dnsName.getOctets();
        int n4 = 12 + s + 4;
        Packet packet = new Packet(n4);
        int n5 = bl ? 256 : 0;
        packet.putShort(n, 0);
        packet.putShort(n5, 2);
        packet.putShort(1, 4);
        packet.putShort(0, 6);
        packet.putInt(0, 8);
        this.makeQueryName(dnsName, packet, 12);
        packet.putShort(n3, 12 + s);
        packet.putShort(n2, 12 + s + 2);
        return packet;
    }

    private void makeQueryName(DnsName dnsName, Packet packet, int n) {
        for (int i = dnsName.size() - 1; i >= 0; --i) {
            String string = dnsName.get(i);
            int n2 = string.length();
            packet.putByte(n2, n++);
            for (int j = 0; j < n2; ++j) {
                packet.putByte(string.charAt(j), n++);
            }
        }
        if (!dnsName.hasRootLabel()) {
            packet.putByte(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] lookupResponse(Integer n) throws NamingException {
        byte[] byArray;
        if (debug) {
            DnsClient.dprint("LOOKUP for: " + n + "\tResponse Q:" + this.resps);
        }
        if ((byArray = this.resps.get(n)) != null) {
            this.checkResponseCode(new Header(byArray, byArray.length));
            Object object = this.queuesLock;
            synchronized (object) {
                this.resps.remove(n);
                this.reqs.remove(n);
            }
            if (debug) {
                DnsClient.dprint("FOUND (" + Thread.currentThread() + ") for:" + n);
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMatchResponse(byte[] byArray, int n) throws NamingException {
        Header header = new Header(byArray, byArray.length);
        if (header.query) {
            throw new CommunicationException("DNS error: expecting response");
        }
        if (!this.reqs.contains(n)) {
            return false;
        }
        if (header.xid == n) {
            if (debug) {
                DnsClient.dprint("XID MATCH:" + n);
            }
            this.checkResponseCode(header);
            Object object = this.queuesLock;
            synchronized (object) {
                this.resps.remove(n);
                this.reqs.remove(n);
            }
            return true;
        }
        Object object = this.queuesLock;
        synchronized (object) {
            if (this.reqs.contains(n)) {
                this.resps.put(n, byArray);
            }
        }
        if (debug) {
            DnsClient.dprint("NO-MATCH SEND ID:" + n + " RECVD ID:" + header.xid + "    Response Q:" + this.resps + "    Reqs size:" + this.reqs.size());
        }
        return false;
    }

    private void checkResponseCode(Header header) throws NamingException {
        int n = header.rcode;
        if (n == 0) {
            return;
        }
        String string = n < rcodeDescription.length ? rcodeDescription[n] : "DNS error";
        string = string + " [response code " + n + "]";
        switch (n) {
            case 2: {
                throw new ServiceUnavailableException(string);
            }
            case 3: {
                throw new NameNotFoundException(string);
            }
            case 4: 
            case 5: {
                throw new OperationNotSupportedException(string);
            }
        }
        throw new NamingException(string);
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    private static void dprint(String string) {
        if (debug) {
            System.err.println("DNS: " + string);
        }
    }
}

