/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class CachedJarFile14
extends JarFile {
    private Reference certificatesRef;
    private Reference signerMapCertRef = null;
    private boolean hasStrictSingleSigning;
    private Reference manifestRef = null;
    private Reference codeSourcesRef;
    private Reference codeSourceCertCacheRef = null;
    private String resourceURL;
    private File indexFile;
    private int[] emptySignerIndices = new int[0];
    private static Enumeration emptyEnumeration = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    private static Iterator emptyIterator = Collections.EMPTY_MAP.keySet().iterator();

    public String getName() {
        String string = super.getName();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return string;
        }
        try {
            securityManager.checkPermission(new RuntimePermission("accessDeploymentCache"));
            return string;
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new CachedJarFile14(new File(super.getName()), this.certificatesRef, this.signerMapCertRef, this.hasStrictSingleSigning, this.manifestRef, this.codeSourcesRef, this.codeSourceCertCacheRef, this.resourceURL, this.indexFile);
        }
        catch (IOException iOException) {
            throw new CloneNotSupportedException();
        }
    }

    private CachedJarFile14(File file, Reference reference, Reference reference2, boolean bl, Reference reference3, Reference reference4, Reference reference5, String string, File file2) throws IOException {
        super(file, false);
        this.certificatesRef = reference;
        this.signerMapCertRef = reference2;
        this.hasStrictSingleSigning = bl;
        this.manifestRef = reference3;
        this.codeSourcesRef = reference4;
        this.codeSourceCertCacheRef = reference5;
        this.resourceURL = string;
        this.indexFile = file2;
        MemoryCache.addResourceReference(this, string);
    }

    protected CachedJarFile14(CacheEntry cacheEntry) throws IOException {
        super(new File(cacheEntry.getResourceFilename()), false);
        this.resourceURL = cacheEntry.getURL();
        this.certificatesRef = new SoftReference<Object>(null);
        this.signerMapCertRef = new SoftReference<Object>(null);
        this.hasStrictSingleSigning = false;
        this.manifestRef = new SoftReference<Object>(null);
        this.codeSourcesRef = new SoftReference<Object>(null);
        this.codeSourceCertCacheRef = new SoftReference<Object>(null);
        this.indexFile = cacheEntry.getIndexFile();
        MemoryCache.addResourceReference(this, this.resourceURL);
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        final Enumeration<JarEntry> enumeration = super.entries();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                try {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    return new JarFileEntry(zipEntry);
                }
                catch (InternalError internalError) {
                    throw new InternalError("Error in CachedJarFile entries");
                }
            }
        };
    }

    private synchronized CacheEntry getCacheEntry() {
        if (this.resourceURL == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(this.resourceURL);
        if (cacheEntry == null || !this.indexFile.equals(cacheEntry.getIndexFile())) {
            Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
            if (cacheEntry != null) {
                Trace.println("CachedJarFile getCacheEntry " + this.indexFile + " != " + cacheEntry.getIndexFile() + " for " + this.resourceURL);
            }
            try {
                cacheEntry = Cache.getCacheEntryFromFile(this.indexFile);
                if (cacheEntry == null) {
                    Trace.println("getCacheEntry failed for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
                }
            }
            catch (Exception exception) {
                Trace.ignoredException(exception);
            }
        }
        return cacheEntry;
    }

    public Manifest getManifest() throws IOException {
        if (this.manifestRef == null) {
            return null;
        }
        Manifest manifest = (Manifest)this.manifestRef.get();
        if (manifest == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                manifest = cacheEntry.getManifest();
            } else {
                Trace.println("Warning: NULL cache entry for loaded resource!", TraceLevel.CACHE);
            }
            this.manifestRef = manifest != null ? new SoftReference<Manifest>(manifest) : null;
        }
        return manifest;
    }

    private Map getCertificateMap() {
        if (this.signerMapCertRef == null) {
            return null;
        }
        Map map = (Map)this.signerMapCertRef.get();
        if (map == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                map = cacheEntry.getCertificateMap();
                if (map != null) {
                    this.signerMapCertRef = new SoftReference<Map>(map);
                    if (!map.isEmpty()) {
                        this.hasStrictSingleSigning = cacheEntry.hasStrictSingleSigning();
                    }
                } else {
                    this.signerMapCertRef = null;
                }
            } else {
                Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
            }
        }
        return map;
    }

    private Certificate[] getCertificates() {
        if (this.certificatesRef == null) {
            return null;
        }
        Certificate[] certificateArray = (Certificate[])this.certificatesRef.get();
        if (certificateArray == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                certificateArray = cacheEntry.getCertificates();
                this.certificatesRef = certificateArray != null ? new SoftReference<Certificate[]>(certificateArray) : null;
            } else {
                Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
            }
        }
        return certificateArray;
    }

    private int[] findMatchingSignerIndices(CodeSource codeSource) {
        Map map = this.getCodeSourceCertCache();
        if (map == null) {
            return this.emptySignerIndices;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(codeSource)) continue;
            return (int[])entry.getKey();
        }
        if (codeSource.getCertificates() == null) {
            return this.emptySignerIndices;
        }
        return null;
    }

    Enumeration entryNames(CodeSource[] codeSourceArray) {
        Object object;
        boolean bl = false;
        ArrayList<int[]> arrayList = new ArrayList<int[]>(codeSourceArray.length);
        for (int i = 0; i < codeSourceArray.length; ++i) {
            object = this.findMatchingSignerIndices(codeSourceArray[i]);
            if (object == null) continue;
            if (((int[])object).length > 0) {
                arrayList.add((int[])object);
                continue;
            }
            bl = true;
        }
        Map map = this.getCertificateMap();
        if (map != null && !map.isEmpty() && this.hasStrictSingleSigning && !arrayList.isEmpty()) {
            map = null;
            bl = true;
            arrayList.clear();
        }
        object = arrayList;
        Map map2 = map;
        final Iterator iterator = map2 != null ? map2.keySet().iterator() : emptyIterator;
        Enumeration enumeration = bl ? this.unsignedEntryNames(map2) : emptyEnumeration;
        return new Enumeration((List)object, map2, enumeration){
            String name;
            private final /* synthetic */ List val$signersReq;
            private final /* synthetic */ Map val$signerMap;
            private final /* synthetic */ Enumeration val$enum2;
            {
                this.val$signersReq = list;
                this.val$signerMap = map;
                this.val$enum2 = enumeration;
            }

            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (this.val$signersReq.contains((int[])this.val$signerMap.get(string))) {
                        this.name = string;
                        return true;
                    }
                    Trace.println("entryNames checking signer failed for " + string, TraceLevel.CACHE);
                }
                if (this.val$enum2.hasMoreElements()) {
                    this.name = (String)this.val$enum2.nextElement();
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    private Enumeration unsignedEntryNames(final Map map) {
        final Enumeration enumeration = this.entries();
        return new Enumeration(){
            String name;

            public boolean hasMoreElements() {
                if (this.name != null) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    String string = zipEntry.getName();
                    if (zipEntry.isDirectory() || CacheEntry.isSigningRelated(string) || map != null && map.get(string) != null) continue;
                    this.name = string;
                    return true;
                }
                return false;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String string = this.name;
                    this.name = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    CodeSource[] getCodeSources(URL uRL) {
        if (this.codeSourcesRef == null) {
            return null;
        }
        CodeSource[] codeSourceArray = (CodeSource[])this.codeSourcesRef.get();
        if (codeSourceArray == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                codeSourceArray = cacheEntry.getCodeSources(uRL);
                this.codeSourcesRef = codeSourceArray != null ? new SoftReference<CodeSource[]>(codeSourceArray) : null;
            } else {
                Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
            }
        }
        return codeSourceArray;
    }

    Map getCodeSourceCertCache() {
        if (this.codeSourceCertCacheRef == null) {
            return null;
        }
        Map map = (Map)this.codeSourceCertCacheRef.get();
        if (map == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                map = cacheEntry.getCodeSourceCertCache();
                this.codeSourceCertCacheRef = map != null ? new SoftReference<Map>(map) : null;
            } else {
                Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
            }
        }
        return map;
    }

    CodeSource getCodeSource(URL uRL, String string) {
        Map map;
        Map map2 = this.getCertificateMap();
        int[] nArray = null;
        nArray = map2 == null || map2.isEmpty() ? null : (this.hasStrictSingleSigning ? (!CacheEntry.isSigningRelated(string) && !string.endsWith("/") ? (int[])map2.get(null) : null) : (int[])map2.get(string));
        if (nArray != null && (map = this.getCodeSourceCertCache()) != null) {
            return (CodeSource)map.get(nArray);
        }
        return CacheEntry.getUnsignedCS(uRL);
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            Manifest manifest = CachedJarFile14.this.getManifest();
            if (manifest != null) {
                return manifest.getAttributes(this.getName());
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certificateArray = null;
            int[] nArray = this.getCertIndices();
            Certificate[] certificateArray2 = CachedJarFile14.this.getCertificates();
            if (certificateArray2 != null && nArray != null) {
                certificateArray = new Certificate[certificateArray2.length];
                for (int i = 0; i < certificateArray2.length; ++i) {
                    certificateArray[i] = certificateArray2[nArray[i]];
                }
            }
            return certificateArray;
        }

        private int[] getCertIndices() {
            Map map = CachedJarFile14.this.getCertificateMap();
            String string = this.getName();
            if (map == null || map.isEmpty()) {
                return null;
            }
            if (CachedJarFile14.this.hasStrictSingleSigning) {
                if (!CacheEntry.isSigningRelated(string) && !string.endsWith("/")) {
                    return (int[])map.get(null);
                }
                return null;
            }
            return (int[])map.get(string);
        }
    }
}

