/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.Formatter;
import biz.papercut.pcng.util.NetworkUtils;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.spi.LoggingEvent;

public class CustomRollingFileAppender
extends RollingFileAppender {
    private static final long START_TIME = System.currentTimeMillis();

    public CustomRollingFileAppender() {
    }

    public CustomRollingFileAppender(Layout arg0, String arg1, boolean arg2) throws IOException {
        super(arg0, arg1, arg2);
    }

    public CustomRollingFileAppender(Layout arg0, String arg1) throws IOException {
        super(arg0, arg1);
    }

    protected void subAppend(LoggingEvent event) {
        String[] s;
        Object msg;
        String formattedLog = this.layout.format(event);
        if (event.getLevel().equals((Object)Level.DEBUG) && event.getLoggerName().equals("org.hibernate.jdbc.ConnectionManager") && (msg = event.getMessage()) instanceof String) {
            int indexEnd;
            int indexStart;
            String msgStr = (String)msg;
            if (msgStr.equals("running Session.finalize()")) {
                return;
            }
            if (msgStr.startsWith("closing JDBC connection") && (indexStart = formattedLog.indexOf(" [ (open ")) > 10 && (indexEnd = formattedLog.indexOf(")]", indexStart)) > 0) {
                String remove = formattedLog.substring(indexStart, indexEnd + 2);
                formattedLog = formattedLog.replace(remove, "");
            }
        }
        this.qw.write(formattedLog);
        if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
            for (String line : s) {
                if (line.contains("biz.papercut.pcng.")) {
                    line = line.replaceAll("biz\\.papercut\\.pcng\\.", "...");
                }
                this.qw.write(line);
                this.qw.write(Layout.LINE_SEP);
            }
        }
        if (this.immediateFlush) {
            this.qw.flush();
        }
        if (this.fileName != null && ((CountingQuietWriter)this.qw).getCount() >= this.maxFileSize) {
            this.dumpDateTime("# Log closed at: ");
            this.rollOver();
            this.dumpApplicationInfo();
            this.dumpDateTime("# Log opened at: ");
        }
    }

    private void dumpApplicationInfo() {
        StringBuilder sb = new StringBuilder(800);
        sb.append("# Application version: ").append(ApplicationInfo.getInstance().getFullVersionWithPlatformInfo());
        sb.append(Layout.LINE_SEP);
        double maxMemoryMB = (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0;
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        double freeSpaceMB = -1.0;
        try {
            File logFile = new File(this.fileName);
            String logDir = logFile.getParentFile().getAbsolutePath();
            long freeSpaceBytes = IOUtils.getFreeSpace(logDir);
            freeSpaceMB = freeSpaceBytes < 0L ? -1.0 : (double)freeSpaceBytes / 1024.0 / 1024.0;
        }
        catch (Exception e) {
            // empty catch block
        }
        long uptimeMillis = System.currentTimeMillis() - START_TIME;
        String uptime = uptimeMillis > 86400000L ? Formatter.formatNumber((double)uptimeMillis / 8.64E7, 2, Locale.US) + " days" : (uptimeMillis > 3600000L ? Formatter.formatNumber((double)uptimeMillis / 3600000.0, 2, Locale.US) + " hours" : Formatter.formatNumber((double)uptimeMillis / 60000.0, 2, Locale.US) + " minutes");
        List<String> ipAddresses = NetworkUtils.getAllIpAddresses();
        sb.append("# System details: max memory: ").append(Formatter.formatNumber(maxMemoryMB, 1, Locale.US)).append(" MB").append(", processors: ").append(availableProcessors).append(freeSpaceMB < 0.0 ? "" : ", free space: " + Formatter.formatNumber(freeSpaceMB, 1, Locale.US) + " MB").append(", uptime: " + uptime).append(", hostname: " + NetworkUtils.getComputerName()).append(", IP addresses: " + ipAddresses + (ipAddresses.size() <= 1 ? "" : " (Primary: " + NetworkUtils.getIpAddress() + ")")).append(", runtime: ").append(System.getProperty("java.runtime.version")).append(", time-zone: ").append(TimeZone.getDefault().getID()).append(", calendar: ").append(Calendar.getInstance().getClass().getSimpleName()).append(", locale: ").append(Locale.getDefault()).append(", encoding: ").append(Charset.defaultCharset());
        sb.append(Layout.LINE_SEP);
        this.qw.write(sb.toString());
        if (this.immediateFlush) {
            this.qw.flush();
        }
    }

    private void dumpDateTime(String prefix) {
        String dateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,S").format(new Date());
        this.qw.write(prefix + dateTime + Layout.LINE_SEP);
        if (this.immediateFlush) {
            this.qw.flush();
        }
    }
}

