/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import biz.papercut.pcng.util.swing.DialogUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SwingUtils {
    private static final Log logger = LogFactory.getLog(SwingUtils.class);

    private SwingUtils() {
    }

    public static boolean isLocaleThatHasFontDisplayProblems() {
        String langCode = Locale.getDefault().getLanguage().toLowerCase();
        return langCode.equals("zh") || langCode.equals("ja") || langCode.equals("ko");
    }

    public static void setupSystemLookAndFeel() {
        SwingUtils.runOnEventThread(new Runnable(){

            public void run() {
                boolean winLAFEnabled = false;
                if (SystemUtils.IS_OS_WINDOWS && !SwingUtils.isLocaleThatHasFontDisplayProblems()) {
                    try {
                        UIManager.setLookAndFeel("net.java.plaf.windows.WindowsLookAndFeel");
                        winLAFEnabled = true;
                    }
                    catch (Throwable t) {
                        logger.debug((Object)"Could not enable WinLAF, falling back to system LAF.");
                    }
                }
                if (!winLAFEnabled) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Throwable t) {
                        logger.debug((Object)"Could not enable system LAF, using default LAF.");
                    }
                }
            }
        }, true);
    }

    public static void addEscapeKeyHandler(JComponent component, final ActionListener actionListener) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction escapeAction = new AbstractAction("escape"){

            public void actionPerformed(ActionEvent e) {
                actionListener.actionPerformed(e);
            }
        };
        component.getInputMap(2).put(stroke, escapeAction.getValue("Name"));
        component.getActionMap().put(escapeAction.getValue("Name"), escapeAction);
    }

    public static void changeDefaultFontSizes(final double scale) {
        SwingUtils.runOnEventThread(new Runnable(){

            public void run() {
                try {
                    UIDefaults defaults = UIManager.getDefaults();
                    Enumeration keys = defaults.keys();
                    while (keys.hasMoreElements()) {
                        Object key = keys.nextElement();
                        Object value = defaults.get(key);
                        if (value == null || !(value instanceof Font)) continue;
                        UIManager.put(key, null);
                        Font font = UIManager.getFont(key);
                        if (font == null) continue;
                        float size = font.getSize2D();
                        UIManager.put(key, new FontUIResource(font.deriveFont((float)((double)size * scale))));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, true);
    }

    public static Color getColorWithAlpha(Color baseColor, float alpha) {
        float[] rgb = baseColor.getRGBComponents(null);
        return new Color(rgb[0], rgb[1], rgb[2], alpha);
    }

    public static JDialog createAlwaysOnTopOkDialog(String title, String message, int messageType) {
        JOptionPane pane = new JOptionPane(message, messageType);
        JDialog dialog = pane.createDialog(null, title);
        DialogUtils.setAlwaysOnTop(dialog, true);
        return dialog;
    }

    public static boolean setWindowAlpha(Window win, float alpha) {
        boolean success = false;
        try {
            Class<?> awtutil = Class.forName("com.sun.awt.AWTUtilities");
            Method setWindowOpaque = awtutil.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            setWindowOpaque.invoke(null, win, Float.valueOf(alpha));
            success = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!success && SystemUtils.IS_OS_MAC) {
            try {
                if (win instanceof JFrame) {
                    JFrame frame = (JFrame)win;
                    frame.getRootPane().putClientProperty("Window.alpha", Float.valueOf(alpha));
                    success = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        GraphicsConfiguration graphicsConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (image.getColorModel().equals(graphicsConfig.getColorModel())) {
            return image;
        }
        int transparency = 3;
        try {
            transparency = image.getTransparency();
        }
        catch (Throwable e) {
            // empty catch block
        }
        BufferedImage compatibleImage = graphicsConfig.createCompatibleImage(image.getWidth(), image.getHeight(), transparency);
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static void setOpaqueIfRequired(final JButton button) {
        SwingUtils.runOnEventThread(new Runnable(){

            public void run() {
                try {
                    Class<?> windowsLookAndFeel = Class.forName("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    LookAndFeel laf = UIManager.getLookAndFeel();
                    if (windowsLookAndFeel.isInstance(laf)) {
                        Toolkit toolkit = Toolkit.getDefaultToolkit();
                        if (Boolean.TRUE.equals(toolkit.getDesktopProperty("win.xpstyle.themeActive"))) {
                            button.setOpaque(false);
                        } else {
                            button.setOpaque(true);
                        }
                    }
                }
                catch (Exception e) {
                    logger.debug((Object)"Unable to determine graphics environment. Defaulting to non-opaque button.");
                    button.setOpaque(false);
                }
            }
        }, true);
    }

    public static void runOnEventThread(Runnable runnable, boolean andWait) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                if (andWait) {
                    SwingUtilities.invokeAndWait(runnable);
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException ite) {
                logger.error((Object)ite.getMessage(), (Throwable)ite);
            }
        }
    }
}

