/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.Messages;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MSWindowsUtils {
    private static final Log logger = LogFactory.getLog(MSWindowsUtils.class);
    private static boolean _initialised = false;
    private static boolean _initialiseFailed = false;

    private MSWindowsUtils() {
    }

    public static boolean isWindows8OrHigher() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        String osVersion = SystemUtils.OS_VERSION;
        logger.info((Object)("Windows osVersion=" + osVersion));
        try {
            Pattern p = Pattern.compile("^(\\d+)\\.(\\d+)$");
            Matcher m = p.matcher(osVersion);
            if (!m.matches()) {
                logger.debug((Object)"Windows version has unexpected format");
                return false;
            }
            int major = Integer.parseInt(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            logger.debug((Object)("Windows version: major=" + major + ",minor=" + minor));
            return major == 6 && minor >= 2 || major > 6;
        }
        catch (Exception e) {
            logger.debug((Object)("Unable to decode Windows version: error = " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private static String formatLines(String msg, int maxLineLen, int maxNumLines) {
        String[] lines;
        StringBuilder sbAll = new StringBuilder();
        int numLines = 0;
        block0: for (String ln : lines = msg.split("\\r?\\n")) {
            String[] words;
            if ((ln = StringUtils.trimToEmpty((String)ln)).length() == 0) continue;
            StringBuilder sb = new StringBuilder();
            for (String w : words = ln.split("\\s+")) {
                sb.append(w);
                if (sb.length() + w.length() >= maxLineLen) {
                    sbAll.append(sb.toString());
                    sbAll.append("\n");
                    if (++numLines >= maxNumLines) break block0;
                    sb = new StringBuilder();
                    continue;
                }
                sb.append(" ");
            }
            if (sb.length() <= 0) continue;
            sbAll.append(sb.toString());
            sbAll.append("\n");
            if (++numLines >= maxNumLines) break;
        }
        return sbAll.toString();
    }

    private static void execToast(final String cmd, final String formattedMsg) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    logger.debug((Object)("Running Toast: cmd=" + cmd));
                    logger.debug((Object)("formattedMsg='" + formattedMsg + "'"));
                    Process p = Runtime.getRuntime().exec(cmd);
                    OutputStream stdin = p.getOutputStream();
                    BufferedWriter input = new BufferedWriter(new OutputStreamWriter(stdin, "UTF-8"));
                    input.write(formattedMsg);
                    input.close();
                    logger.debug((Object)"Toast stdin sent");
                    int exitValue = p.waitFor();
                    logger.debug((Object)("Toast exit value: " + exitValue));
                    if (exitValue < 0) {
                        logger.error((Object)"Toast failed");
                    }
                }
                catch (IOException e) {
                    logger.debug((Object)("Unable to run Toast, error = " + e.getMessage()), (Throwable)e);
                }
                catch (InterruptedException e) {
                    logger.debug((Object)("InterruptedException running Toast, error = " + e.getMessage()), (Throwable)e);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static void sendWindows8Message(String msg) {
        if (StringUtils.isBlank((String)msg)) {
            throw new IllegalArgumentException("Invalid message");
        }
        String formattedMsg = null;
        String cmd = null;
        File clientLibDir = new File(UserClientUtils.getHomeDirectory(), "lib");
        try {
            String toastPath = new File(clientLibDir, "pc-toast-notify.exe").getCanonicalPath();
            String logoPath = new File(clientLibDir, "icon-toast-notify.png").getCanonicalPath();
            String fullMsg = ApplicationInfo.getInstance().getApplicationName() + "\n" + msg;
            formattedMsg = MSWindowsUtils.formatLines(fullMsg, 25, 3);
            logger.debug((Object)("formattedMsg=\n" + formattedMsg));
            File customLogoFile = UserClientUtils.getCustomIconImage();
            if (customLogoFile != null) {
                logoPath = customLogoFile.getAbsolutePath();
                logger.debug((Object)("Using custom icon image: " + logoPath));
            } else {
                logger.debug((Object)("No customer logo defined. Using " + logoPath));
            }
            cmd = toastPath + " " + logoPath;
        }
        catch (IOException e) {
            logger.debug((Object)("Unable to construct toast command , error = " + e.getMessage()), (Throwable)e);
            return;
        }
        MSWindowsUtils.execToast(cmd, formattedMsg);
    }

    public static void sendWindows8PrintSystemAlert() {
        if (!MSWindowsUtils.isWindows8OrHigher()) {
            return;
        }
        String msg = Messages.getString(MSWindowsUtils.class, (String)"MSWindowsUtils.print-system-alert", (String[])new String[0]);
        MSWindowsUtils.sendWindows8Message(msg);
    }

    public static void addWindowListenerToBringWindowToFrontOnOpen(final Window window) {
        window.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                if (!MSWindowsUtils.forceWindowToTop(window)) {
                    window.toFront();
                }
            }
        });
    }

    public static boolean forceWindowToTop(Window window) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            return false;
        }
        if (!MSWindowsUtils.ensureDllIsInitialised()) {
            return false;
        }
        MSWindowsUtils.forceWindowToTopInternal(window);
        MSWindowsUtils.sendWindows8PrintSystemAlert();
        return true;
    }

    private static synchronized boolean ensureDllIsInitialised() {
        if (!_initialised && !_initialiseFailed) {
            try {
                File clientLibDir = new File(UserClientUtils.getHomeDirectory(), "lib");
                String clientDllPath = new File(clientLibDir, "clientjni.dll").getCanonicalPath();
                logger.debug((Object)("Loading dll: " + clientDllPath));
                System.load(clientDllPath);
                File javaHomeBin = new File(System.getProperty("java.home"), "bin");
                File jawtDllFile = new File(javaHomeBin, "jawt.dll");
                String jawtDllPath = jawtDllFile.getCanonicalPath();
                if (!jawtDllFile.exists()) {
                    throw new ApplicationException("Cannot find jawt.dll here: " + jawtDllPath);
                }
                MSWindowsUtils.initialise(jawtDllPath);
                _initialised = true;
            }
            catch (Throwable t) {
                logger.error((Object)("Error loading clientjni.dll: " + t.getMessage()), t);
                _initialiseFailed = true;
            }
        }
        return _initialised;
    }

    private static native void initialise(String var0);

    private static native void forceWindowToTopInternal(Window var0);
}

