/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.NetworkUtils;
import biz.papercut.pcng.util.PropertiesUtils;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClientConfigFile {
    private static final String DEFAULT_CONFIG_NAME = "config.properties";
    private static final String MAC_USER_LEVEL_CONFIG_DIR = "Library/Preferences/PCClient";
    private static final String MAC_USER_LEVEL_CONFIG = "config.properties";
    private static final String GENERAL_USER_LEVEL_CONFIG = "pc-client.properties";
    private static final String AUTH_COOKIE_FILE_NAME = "pc-auth.cookie";
    private static final Log logger = LogFactory.getLog(ClientConfigFile.class);

    private ClientConfigFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadConfig() {
        String configFileName = new File(UserClientUtils.getHomeDirectory(), "config.properties").getAbsolutePath();
        if (!new File(configFileName).exists() && new File("src/conf/config.properties").exists()) {
            configFileName = "src/conf/config.properties";
        }
        Properties prop = new Properties();
        FileInputStream fin = null;
        try {
            logger.debug((Object)("Reading configuration from file: " + configFileName));
            fin = new FileInputStream(configFileName);
            prop.load(fin);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to read config file: " + configFileName), (Throwable)e);
            throw new ApplicationException("Unable to read default config file", (Throwable)e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception e) {}
            }
        }
        File userLevelConfigFile = ClientConfigFile.getUserLevelConfigFile();
        Properties userProp = new Properties();
        if (userLevelConfigFile != null && userLevelConfigFile.exists()) {
            try {
                logger.debug((Object)("Reading user level configuration from file: " + userLevelConfigFile.getPath()));
                fin = new FileInputStream(userLevelConfigFile);
                userProp.load(fin);
                prop.putAll((Map<?, ?>)userProp);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to read user level config file: " + userLevelConfigFile.getPath()), (Throwable)e);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return prop;
    }

    public static void saveUsernameToUserLevelConfig(String newUserName) {
        File userLevelConfigFile;
        block12: {
            userLevelConfigFile = ClientConfigFile.getUserLevelConfigFile();
            logger.debug((Object)("Saving username: " + newUserName + " to: " + userLevelConfigFile));
            Properties userProp = new Properties();
            if (!userLevelConfigFile.exists()) break block12;
            logger.debug((Object)("Update existing properties file: " + userLevelConfigFile));
            FileInputStream fin = null;
            try {
                logger.debug((Object)("Reading user level configuration from file: " + userLevelConfigFile.getPath()));
                fin = new FileInputStream(userLevelConfigFile);
                userProp.load(fin);
            }
            catch (Exception e) {
                try {
                    String errMsg = "Unable to read user level config file: " + userLevelConfigFile.getPath();
                    logger.error((Object)errMsg, (Throwable)e);
                    throw new ApplicationException(errMsg, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fin);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fin);
            userProp.setProperty("user", newUserName);
            try {
                PropertiesUtils.saveUpdatedProperties((String)userLevelConfigFile.getPath(), (Properties)userProp);
            }
            catch (IOException e) {
                throw new ApplicationException("Unable to save user level config file", (Throwable)e);
            }
        }
        try {
            File parentDir = userLevelConfigFile.getParentFile();
            parentDir.mkdirs();
        }
        catch (Exception e) {
            // empty catch block
        }
        PrintWriter file = null;
        try {
            file = new PrintWriter(new FileWriter(userLevelConfigFile));
            file.println("#" + ApplicationInfo.getInstance().getApplicationName() + " User-level Client Config");
            file.println("user=" + newUserName);
        }
        catch (IOException e) {
            try {
                String errMsg = "Unable to write user level config file to: " + userLevelConfigFile.getPath();
                logger.error((Object)errMsg, (Throwable)e);
                throw new ApplicationException(errMsg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(file);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)file);
    }

    private static File getUserLevelConfigDirectory() {
        String homeDir = NetworkUtils.getUserHomeDirectory();
        if (SystemUtils.IS_OS_MAC_OSX) {
            return new File(homeDir, MAC_USER_LEVEL_CONFIG_DIR);
        }
        return new File(homeDir);
    }

    private static File getUserLevelConfigFile() {
        File userLevelConfigFile = null;
        File userConfDir = ClientConfigFile.getUserLevelConfigDirectory();
        userLevelConfigFile = SystemUtils.IS_OS_MAC_OSX ? new File(userConfDir, "config.properties") : new File(userConfDir, GENERAL_USER_LEVEL_CONFIG);
        return userLevelConfigFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadUserAuthCookie() {
        File authFile = new File(ClientConfigFile.getUserLevelConfigDirectory(), AUTH_COOKIE_FILE_NAME);
        if (!authFile.exists() || !authFile.isFile()) {
            return null;
        }
        String cookie = null;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(authFile);
            Properties p = new Properties();
            p.load(fin);
            cookie = p.getProperty("cookie");
        }
        catch (IOException e) {
            try {
                logger.error((Object)("Failed to read auth cookie from file: " + authFile + ". " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fin);
        }
        IOUtils.closeQuietly((InputStream)fin);
        return StringUtils.trimToNull((String)cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveUserAuthCookie(String authCookie) {
        FileOutputStream fout;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Saving auth cookie: " + authCookie));
        }
        if ((authCookie = StringUtils.trimToEmpty((String)authCookie)).length() == 0) {
            return;
        }
        File userConfDir = ClientConfigFile.getUserLevelConfigDirectory();
        if (!userConfDir.exists()) {
            userConfDir.mkdirs();
        }
        File authFile = new File(userConfDir, AUTH_COOKIE_FILE_NAME);
        if (SystemUtils.IS_OS_UNIX && !authFile.exists()) {
            fout = null;
            try {
                fout = new FileOutputStream(authFile);
                IOUtils.closeQuietly((OutputStream)fout);
                new ProcessBuilder("chmod", "600", authFile.getAbsolutePath()).start();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Problem setting up auth cookie file permissions. " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fout);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fout);
            }
            IOUtils.closeQuietly((OutputStream)fout);
        }
        fout = null;
        try {
            Properties p = new Properties();
            p.setProperty("cookie", authCookie);
            fout = new FileOutputStream(authFile);
            p.store(fout, "");
            fout.flush();
        }
        catch (IOException ioe) {
            try {
                logger.error((Object)("Unable to save auth cookie file: " + authFile.getPath() + ". " + ioe.getMessage()), (Throwable)ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fout);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fout);
        }
        IOUtils.closeQuietly((OutputStream)fout);
    }

    public static void deleteUserAuthCookie() {
        File authFile = new File(ClientConfigFile.getUserLevelConfigDirectory(), AUTH_COOKIE_FILE_NAME);
        if (authFile.exists()) {
            authFile.delete();
        }
    }
}

