/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.peer.DialogPeer;
import java.util.List;
import sun.awt.AWTAccessor;
import sun.awt.im.InputMethodManager;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WWindowPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WDialogPeer
extends WWindowPeer
implements DialogPeer {
    static final Color defaultBackground = SystemColor.control;
    boolean needDefaultBackground;

    WDialogPeer(Dialog dialog) {
        super(dialog);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
    }

    @Override
    native void create(WComponentPeer var1);

    native void showModal();

    native void endModal();

    @Override
    void initialize() {
        Dialog dialog = (Dialog)this.target;
        if (this.needDefaultBackground) {
            dialog.setBackground(defaultBackground);
        }
        super.initialize();
        if (dialog.getTitle() != null) {
            this.setTitle(dialog.getTitle());
        }
        this.setResizable(dialog.isResizable());
    }

    @Override
    protected void realShow() {
        Dialog dialog = (Dialog)this.target;
        if (dialog.getModalityType() != Dialog.ModalityType.MODELESS) {
            this.showModal();
            this.visible = true;
        } else {
            super.realShow();
        }
    }

    @Override
    public void hide() {
        Dialog dialog = (Dialog)this.target;
        if (dialog.getModalityType() != Dialog.ModalityType.MODELESS) {
            this.endModal();
            this.visible = false;
        } else {
            super.hide();
        }
    }

    @Override
    public void blockWindows(List<Window> list) {
        for (Window window : list) {
            WWindowPeer wWindowPeer = (WWindowPeer)AWTAccessor.getComponentAccessor().getPeer(window);
            if (wWindowPeer == null) continue;
            wWindowPeer.setModalBlocked((Dialog)this.target, true);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (((Dialog)this.target).isUndecorated()) {
            return super.getMinimumSize();
        }
        return new Dimension(WDialogPeer.getSysMinWidth(), WDialogPeer.getSysMinHeight());
    }

    @Override
    boolean isTargetUndecorated() {
        return ((Dialog)this.target).isUndecorated();
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.constrainBounds(n, n2, n3, n4);
        if (((Dialog)this.target).isUndecorated()) {
            super.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.reshapeFrame(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void setDefaultColor() {
        this.needDefaultBackground = true;
    }

    native void pSetIMMOption(String var1);

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest((Component)this.target);
    }
}

