/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

import biz.papercut.pcng.util.AbstractResponse;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientAuthResponse
extends AbstractResponse {
    private static final String FIELD_SUCCESS = "success";
    private static final String FIELD_ERROR_MSG = "error-msg";
    private static final String FIELD_REALNAME = "realname";
    private static final String FIELD_AUTH_COOKIE = "authCookie";
    private String _realName;
    private String _authCookie;

    private ClientAuthResponse(boolean success, String realName, String authCookie, String errorMessage) {
        super(success, errorMessage);
        this.setRealName(realName);
        this._authCookie = StringUtils.trimToEmpty((String)authCookie);
    }

    public static ClientAuthResponse newSuccess(String realName, String authCookie) {
        return new ClientAuthResponse(true, realName, authCookie, "");
    }

    public static ClientAuthResponse newFail(String errorMessage) {
        return new ClientAuthResponse(false, "", "", errorMessage);
    }

    public ClientAuthResponse(Hashtable<String, Object> data) {
        this(false, "", "", "");
        String strValue;
        if (data.size() == 0) {
            return;
        }
        Boolean boolValue = (Boolean)data.get(FIELD_SUCCESS);
        if (boolValue != null) {
            this.setSuccess(boolValue);
        }
        if ((strValue = (String)data.get(FIELD_ERROR_MSG)) != null) {
            this.setErrorMessage(strValue);
        }
        if ((strValue = (String)data.get(FIELD_REALNAME)) != null) {
            this.setRealName(strValue);
        }
        if ((strValue = (String)data.get(FIELD_AUTH_COOKIE)) != null) {
            this._authCookie = StringUtils.trimToEmpty((String)strValue);
        }
    }

    public Hashtable<String, Object> saveToHashtable() {
        Hashtable<String, Object> data = new Hashtable<String, Object>(2);
        data.put(FIELD_SUCCESS, this.isSuccess());
        if (!this.isSuccess() && StringUtils.isNotBlank((String)this.getErrorMessage())) {
            data.put(FIELD_ERROR_MSG, this.getErrorMessage());
        }
        data.put(FIELD_REALNAME, this.getRealName());
        if (StringUtils.isNotBlank((String)this.getAuthCookie())) {
            data.put(FIELD_AUTH_COOKIE, this.getAuthCookie());
        }
        return data;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(StringUtils.trimToEmpty((String)errorMessage));
    }

    public String getRealName() {
        return this._realName;
    }

    public void setRealName(String realName) {
        this._realName = StringUtils.trimToEmpty((String)realName);
    }

    public final String getAuthCookie() {
        return this._authCookie;
    }
}

