/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.factories;

import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public final class DefaultComponentFactory
implements ComponentFactory {
    private static final DefaultComponentFactory INSTANCE = new DefaultComponentFactory();
    private static final char MNEMONIC_MARKER = '&';
    private static Boolean cachedIsLafAqua;
    private static boolean changeHandlerRegistered;

    private DefaultComponentFactory() {
    }

    public static DefaultComponentFactory getInstance() {
        return INSTANCE;
    }

    public JLabel createLabel(String textWithMnemonic) {
        JLabel label = new JLabel();
        DefaultComponentFactory.setTextAndMnemonic(label, textWithMnemonic);
        return label;
    }

    public JLabel createTitle(String textWithMnemonic) {
        TitleLabel label = new TitleLabel();
        DefaultComponentFactory.setTextAndMnemonic(label, textWithMnemonic);
        label.setVerticalAlignment(0);
        return label;
    }

    public JComponent createSeparator(String textWithMnemonic) {
        return this.createSeparator(textWithMnemonic, 2);
    }

    public JComponent createSeparator(String textWithMnemonic, int alignment) {
        if (textWithMnemonic == null || textWithMnemonic.length() == 0) {
            return new JSeparator();
        }
        JLabel title = this.createTitle(textWithMnemonic);
        title.setHorizontalAlignment(alignment);
        return this.createSeparator(title);
    }

    public JComponent createSeparator(JLabel label) {
        if (label == null) {
            throw new NullPointerException("The label must not be null.");
        }
        JPanel panel = new JPanel(new TitledSeparatorLayout(!DefaultComponentFactory.isLafAqua()));
        panel.setOpaque(false);
        panel.add(label);
        panel.add(new JSeparator());
        if (label.getHorizontalAlignment() == 0) {
            panel.add(new JSeparator());
        }
        return panel;
    }

    private static void setTextAndMnemonic(JLabel label, String textWithMnemonic) {
        int end;
        int markerIndex = textWithMnemonic.indexOf(38);
        if (markerIndex == -1) {
            label.setText(textWithMnemonic);
            return;
        }
        int mnemonicIndex = -1;
        int begin = 0;
        int length = textWithMnemonic.length();
        int quotedMarkers = 0;
        StringBuffer buffer = new StringBuffer();
        do {
            if (markerIndex + 1 < length && textWithMnemonic.charAt(markerIndex + 1) == '&') {
                end = markerIndex + 1;
                ++quotedMarkers;
            } else {
                end = markerIndex;
                if (mnemonicIndex == -1) {
                    mnemonicIndex = markerIndex - quotedMarkers;
                }
            }
            buffer.append(textWithMnemonic.substring(begin, end));
        } while ((markerIndex = (begin = end + 1) < length ? textWithMnemonic.indexOf(38, begin) : -1) != -1);
        buffer.append(textWithMnemonic.substring(begin));
        String text = buffer.toString();
        label.setText(text);
        if (mnemonicIndex != -1 && mnemonicIndex < text.length()) {
            label.setDisplayedMnemonic(text.charAt(mnemonicIndex));
            label.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private static synchronized void ensureLookAndFeelChangeHandlerRegistered() {
        if (!changeHandlerRegistered) {
            UIManager.addPropertyChangeListener(new LookAndFeelChangeHandler());
            changeHandlerRegistered = true;
        }
    }

    private static boolean isLafAqua() {
        if (cachedIsLafAqua == null) {
            cachedIsLafAqua = DefaultComponentFactory.computeIsLafAqua();
            DefaultComponentFactory.ensureLookAndFeelChangeHandlerRegistered();
        }
        return cachedIsLafAqua;
    }

    private static boolean computeIsLafAqua() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return laf.getName().startsWith("Mac OS X Aqua");
    }

    static {
        changeHandlerRegistered = false;
    }

    private static class LookAndFeelChangeHandler
    implements PropertyChangeListener {
        private LookAndFeelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            cachedIsLafAqua = null;
        }
    }

    private static final class TitledSeparatorLayout
    implements LayoutManager {
        private final boolean centerSeparators;

        private TitledSeparatorLayout(boolean centerSeparators) {
            this.centerSeparators = centerSeparators;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            JLabel label = this.getLabel(parent);
            Dimension labelSize = ((Component)label).getPreferredSize();
            Insets insets = parent.getInsets();
            int width = labelSize.width + insets.left + insets.right;
            int height = labelSize.height + insets.top + insets.bottom;
            return new Dimension(width, height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Dimension size = parent.getSize();
                Insets insets = parent.getInsets();
                int width = size.width - insets.left - insets.right;
                JLabel label = this.getLabel(parent);
                Dimension labelSize = label.getPreferredSize();
                int labelWidth = labelSize.width;
                int labelHeight = labelSize.height;
                Component separator1 = parent.getComponent(1);
                int separatorHeight = separator1.getPreferredSize().height;
                FontMetrics metrics = label.getFontMetrics(label.getFont());
                int ascent = metrics.getMaxAscent();
                int hGapDlu = this.centerSeparators ? 3 : 1;
                int hGap = Sizes.dialogUnitXAsPixel(hGapDlu, label);
                int vOffset = this.centerSeparators ? 1 + (labelHeight - separatorHeight) / 2 : ascent - separatorHeight / 2;
                int alignment = label.getHorizontalAlignment();
                int y = insets.top;
                if (alignment == 2) {
                    int x = insets.left;
                    label.setBounds(x, y, labelWidth, labelHeight);
                    x += labelWidth;
                    int separatorWidth = size.width - insets.right - (x += hGap);
                    separator1.setBounds(x, y + vOffset, separatorWidth, separatorHeight);
                } else if (alignment == 4) {
                    int x = insets.left + width - labelWidth;
                    label.setBounds(x, y, labelWidth, labelHeight);
                    x -= hGap;
                    int separatorWidth = --x - insets.left;
                    separator1.setBounds(insets.left, y + vOffset, separatorWidth, separatorHeight);
                } else {
                    int xOffset = (width - labelWidth - 2 * hGap) / 2;
                    int x = insets.left;
                    separator1.setBounds(x, y + vOffset, xOffset - 1, separatorHeight);
                    x += xOffset;
                    label.setBounds(x += hGap, y, labelWidth, labelHeight);
                    x += labelWidth;
                    Component separator2 = parent.getComponent(2);
                    int separatorWidth = size.width - insets.right - (x += hGap);
                    separator2.setBounds(x, y + vOffset, separatorWidth, separatorHeight);
                }
            }
        }

        private JLabel getLabel(Container parent) {
            return (JLabel)parent.getComponent(0);
        }
    }

    private static final class TitleLabel
    extends JLabel {
        private TitleLabel() {
        }

        private TitleLabel(String text) {
            super(text);
        }

        public void updateUI() {
            super.updateUI();
            Color foreground = UIManager.getColor("TitledBorder.titleColor");
            if (foreground != null) {
                this.setForeground(foreground);
            }
            this.setFont(this.getTitleFont());
        }

        private Font getTitleFont() {
            return DefaultComponentFactory.isLafAqua() ? UIManager.getFont("Label.font").deriveFont(1) : UIManager.getFont("TitledBorder.font");
        }
    }
}

