/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AuthDialog;
import biz.papercut.pcng.client.uit.ClientConfigFile;
import biz.papercut.pcng.client.uit.MSWindowsUtils;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.common.ClientAuthResponse;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.DialogBannerPanel;
import biz.papercut.pcng.util.swing.DialogUtils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdentDialog
extends JDialog {
    private static final Log logger = LogFactory.getLog(IdentDialog.class);
    private JButton _okButton;
    private JButton _cancelButton;
    private JTextField _userNameField;
    private JPasswordField _passwordField;
    private JCheckBox _rememberIdentityCheckBox;
    private UserClientConfig _clientConfig;
    private ServerConnection _serverConnection;

    public IdentDialog(UserClientFrame uit, UserClientConfig clientConfig, ServerConnection connection) {
        super(uit, IdentDialog.format("login", new String[0]), true);
        logger.debug((Object)"Displaying identity dialog");
        DialogUtils.setAlwaysOnTop((Window)this, (boolean)true);
        this.toFront();
        this._serverConnection = connection;
        this._clientConfig = clientConfig;
        this.layoutComponents();
        MSWindowsUtils.addWindowListenerToBringWindowToFrontOnOpen(this);
        DialogUtils.forceRepaintAfterOpened((Window)this);
    }

    private void layoutComponents() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        ClientGlobalConfigFromServer confFromServer = this._clientConfig.getServerGlobalConfig();
        DialogBannerPanel bannerPanel = UserClientUtils.getStandardDialogBanner(IdentDialog.format("login", new String[0]), IdentDialog.format("description", new String[0]), confFromServer);
        contentPanel.add((Component)bannerPanel, "North");
        FormLayout layoutCenter = new FormLayout("15dlu, right:max(pref;40dlu), 3dlu, max(pref;120dlu):grow, 20dlu", "0dlu:grow, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 0dlu:grow");
        layoutCenter.setRowGroups((int[][])new int[][]{{2, 4, 6}});
        JPanel centerPanel = new JPanel();
        DefaultFormBuilder builder = new DefaultFormBuilder(layoutCenter, centerPanel);
        builder.setDefaultDialogBorder();
        builder.setRow(2);
        builder.setColumn(2);
        builder.append((Component)new JLabel(IdentDialog.format("detailed-description", new String[0])), 3);
        builder.nextLine(2);
        builder.setColumn(2);
        this._userNameField = new JTextField();
        builder.append(IdentDialog.format("username", new String[0]), (Component)this._userNameField);
        builder.nextLine(2);
        builder.setColumn(2);
        this._passwordField = new JPasswordField();
        builder.append(IdentDialog.format("password", new String[0]), (Component)this._passwordField);
        builder.nextLine(2);
        builder.setColumn(4);
        boolean remember = this._clientConfig.isAlwaysRequestIdentity();
        this._rememberIdentityCheckBox = new JCheckBox(IdentDialog.format("remember", new String[0]), remember);
        builder.append((Component)this._rememberIdentityCheckBox);
        contentPanel.add((Component)centerPanel, "Center");
        this._okButton = new JButton(IdentDialog.format("ok", new String[0]));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IdentDialog.this.okButtonPressed();
            }
        });
        this._cancelButton = new JButton(IdentDialog.format("cancel", new String[0]));
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IdentDialog.this.cancelButtonPressed();
            }
        });
        FormLayout layoutFooter = new FormLayout("pref:grow", "pref");
        JPanel buttonPanel = new JPanel();
        builder = new DefaultFormBuilder(layoutFooter, buttonPanel);
        builder.setDefaultDialogBorder();
        JPanel buttonPanelInner = ButtonBarFactory.buildOKCancelBar((JButton)this._okButton, (JButton)this._cancelButton);
        builder.append((Component)buttonPanelInner);
        contentPanel.add((Component)buttonPanel, "South");
        this.setContentPane(contentPanel);
        this.getRootPane().setDefaultButton(this._okButton);
        this.pack();
        final int minWidth = (int)this.getSize().getWidth();
        final int minHeight = (int)this.getSize().getHeight();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                IdentDialog.this.setSize(new Dimension(Math.max(minWidth, IdentDialog.this.getWidth()), Math.max(minHeight, IdentDialog.this.getHeight())));
            }
        });
        this.setLocationRelativeTo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void okButtonPressed() {
        try {
            logger.debug((Object)"OK button pressed");
            this.setCursor(Cursor.getPredefinedCursor(3));
            String username = this._userNameField.getText();
            String password = new String(this._passwordField.getPassword());
            ClientAuthResponse response = this._serverConnection.checkIdentity(username, password);
            username = response.getRealName();
            if (response.isSuccess()) {
                this._clientConfig.setDisplayUserName(username);
                this._clientConfig.setUserName(username);
                if (this._rememberIdentityCheckBox.isSelected() && !username.equalsIgnoreCase(System.getProperty("user.name"))) {
                    logger.debug((Object)("Saving identity to file: " + username));
                    ClientConfigFile.saveUsernameToUserLevelConfig(username);
                    logger.debug((Object)"Completed save of identity file.");
                }
                this._clientConfig.setSuccessfullyIdentified(true);
                this.closeDialog();
            } else {
                DialogUtils.showInformationMessageDialog((Component)this, (String)IdentDialog.format("error", new String[0]), (String)response.getErrorMessage());
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Unable to call authentication method: " + e.getMessage()), e);
            DialogUtils.showInformationMessageDialog((Component)this, (String)IdentDialog.format("error", new String[0]), (String)e.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static String format(String key, String ... args) {
        String fullKey = "IdentDialog." + key;
        return Messages.getString(AuthDialog.class, (String)fullKey, (String[])args);
    }

    protected void cancelButtonPressed() {
        logger.debug((Object)"Cancel button pressed");
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
    }
}

