/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.ArrayList;
import java.util.Arrays;

class StringValue {
    private static final boolean compressedStringsEnabled = false;
    private static final boolean stringCacheEnabled = false;
    private static StringCache cache = new StringCache();

    private StringValue() {
    }

    static Object from(char[] cArray) {
        Object object = StringValue.cache.get(cArray);
        return object != null ? object : StringValue.genValue(cArray, 0, cArray.length);
    }

    static boolean getCompressedStringsEnabled() {
        return compressedStringsEnabled;
    }

    static boolean is_byte_array(Object object) {
        return object instanceof byte[];
    }

    static int array_length(Object object) {
        boolean bl = StringValue.is_byte_array(object);
        return bl ? ((byte[])object).length : ((char[])object).length;
    }

    static Object genValue(char[] cArray, int n, int n2) {
        Object object = StringValue.compressValue(cArray, n, n2);
        if (object == null) {
            object = Arrays.copyOfRange(cArray, n, n2);
        }
        return object;
    }

    static Object genValue(Object object, int n, int n2) {
        Object object2;
        if (StringValue.is_byte_array(object)) {
            object2 = Arrays.copyOfRange((byte[])object, n, n2);
        } else {
            object2 = StringValue.compressValue((char[])object, n, n2);
            if (object2 == null) {
                object2 = Arrays.copyOfRange((char[])object, n, n2);
            }
        }
        return object2;
    }

    static Object compressValue(char[] cArray, int n, int n2) {
        if (!compressedStringsEnabled) {
            return null;
        }
        int n3 = n2 - n;
        if (n3 < 0) {
            return null;
        }
        byte[] byArray = new byte[n3 = Math.min(cArray.length - n, n3)];
        if (StringValue.compressedCopy(cArray, n, byArray, 0, n3) == n3) {
            return byArray;
        }
        return null;
    }

    static int compressedCopy(char[] cArray, int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            if (cArray[n] > '\u007f') {
                return 0;
            }
            byArray[n2++] = (byte)cArray[n++];
        }
        return n3;
    }

    static char[] inflateValue(Object object) {
        if (!StringValue.is_byte_array(object)) {
            return (char[])object;
        }
        byte[] byArray = (byte[])object;
        int n = byArray.length;
        char[] cArray = new char[n];
        if (StringValue.inflatedCopy(byArray, 0, cArray, 0, n) != n) {
            throw new RuntimeException("String inflate failure");
        }
        return cArray;
    }

    static void copyValue(Object object, int n, char[] cArray, int n2, int n3) {
        if (!StringValue.is_byte_array(object)) {
            System.arraycopy((char[])object, n, cArray, n2, n3);
        } else {
            int n4;
            if (cArray != null && n >= 0 && n2 >= 0 && n3 >= 0 && n <= ((byte[])object).length - n3 && n2 <= cArray.length - n3 && (n4 = StringValue.inflatedCopy((byte[])object, n, cArray, n2, n3)) == n3) {
                return;
            }
            StringValue.copyInflatedValue(object, n, cArray, n2, n3);
        }
    }

    private static void copyInflatedValue(Object object, int n, char[] cArray, int n2, int n3) {
        char[] cArray2 = StringValue.inflateValue(object);
        System.arraycopy(cArray2, n, cArray, n2, n3);
    }

    static void checkBounds(int n, int n2, int n3) {
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n2 > n - n3) {
            throw new StringIndexOutOfBoundsException(n2 + n3);
        }
    }

    static void copyChars(Object object, int n, char[] cArray, int n2, int n3) {
        char[] cArray2;
        if (StringValue.is_byte_array(object)) {
            StringValue.checkBounds(cArray.length, n2, n3);
            if (StringValue.inflatedCopy((byte[])object, n, cArray, n2, n3) == n3) {
                return;
            }
            cArray2 = StringValue.inflateValue(object);
        } else {
            cArray2 = (char[])object;
        }
        System.arraycopy(cArray2, n, cArray, n2, n3);
    }

    static int copyBytes(Object object, int n, byte[] byArray, int n2, int n3) {
        if (!StringValue.is_byte_array(object)) {
            StringValue.checkBounds(byArray.length, n2, n3);
            int n4 = StringValue.compressedCopy((char[])object, n, byArray, n2, n3);
            return n4;
        }
        System.arraycopy((byte[])object, n, byArray, n2, n3);
        return n3;
    }

    private static int inflatedCopy(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            cArray[n2++] = (char)byArray[n++];
        }
        return n3;
    }

    private static class StringCache {
        private static final int MAX_PROFILE_SIZE = 32;
        private static final int MAX_CACHE_SIZE = 8;
        private static final int STRING_CACHE_CREATE_THRESHOLD = 1000000;
        private static final float STRING_FREQ_THRESHOLD = 0.125f;
        private int allocs;
        private ArrayList<StringProfile> profile = new ArrayList();
        private StringCacheEntry[] cache;
        private int cacheSize;
        private StringCacheEntry MRUvalue;
        private boolean profiling = true;
        private boolean cacheInitialized;

        private StringCache() {
        }

        private StringProfile removeColdestProfile() {
            int n = 0;
            int n2 = 0;
            int n3 = 0x40000000;
            for (StringProfile stringProfile : this.profile) {
                if (stringProfile.refs < n3) {
                    n3 = stringProfile.refs;
                    n2 = n;
                }
                ++n;
            }
            return this.profile.remove(n2);
        }

        private StringProfile removeHottestProfile() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (StringProfile stringProfile : this.profile) {
                if (stringProfile.refs > n3) {
                    n3 = stringProfile.refs;
                    n2 = n;
                }
                ++n;
            }
            return this.profile.remove(n2);
        }

        private StringProfile getFromProfile(char[] cArray) {
            for (StringProfile stringProfile : this.profile) {
                if (!Arrays.equals(stringProfile.value, cArray)) continue;
                ++stringProfile.refs;
                return stringProfile;
            }
            return null;
        }

        private void putToProfile(char[] cArray) {
            if (this.profile.size() == 32) {
                this.removeColdestProfile();
            }
            char[] cArray2 = Arrays.copyOf(cArray, cArray.length);
            StringProfile stringProfile = new StringProfile(cArray2);
            stringProfile.refs = 1;
            this.profile.add(stringProfile);
        }

        private void buildCache() {
            ArrayList<char[]> arrayList = new ArrayList<char[]>();
            while (arrayList.size() <= 8) {
                StringProfile stringProfile = this.removeHottestProfile();
                if ((float)stringProfile.refs / (float)this.allocs < 0.125f) break;
                arrayList.add(stringProfile.value);
            }
            this.profile.clear();
            this.cacheSize = arrayList.size();
            if (this.cacheSize > 0) {
                this.cache = new StringCacheEntry[this.cacheSize];
                int n = 0;
                for (char[] cArray : arrayList) {
                    this.cache[n++] = new StringCacheEntry(cArray);
                }
                this.MRUvalue = this.cache[0];
                this.cacheInitialized = true;
            }
            this.profiling = false;
        }

        private Object getFromCache(char[] cArray) {
            if (this.cacheInitialized) {
                for (StringCacheEntry stringCacheEntry : this.cache) {
                    if (stringCacheEntry == this.MRUvalue || !Arrays.equals(stringCacheEntry.getValue(), cArray)) continue;
                    this.MRUvalue = stringCacheEntry;
                    return stringCacheEntry.getCachedValue();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void profile(char[] cArray) {
            ArrayList<StringProfile> arrayList = this.profile;
            synchronized (arrayList) {
                if (!this.profiling) {
                    return;
                }
                StringProfile stringProfile = this.getFromProfile(cArray);
                if (stringProfile == null) {
                    this.putToProfile(cArray);
                }
                if (++this.allocs == 1000000) {
                    this.buildCache();
                }
            }
        }

        private Object get(char[] cArray) {
            if (stringCacheEnabled) {
                if (this.cacheInitialized) {
                    if (Arrays.equals(this.MRUvalue.getValue(), cArray)) {
                        return this.MRUvalue.getCachedValue();
                    }
                    if (this.cacheSize > 1) {
                        return this.getFromCache(cArray);
                    }
                } else if (this.profiling) {
                    this.profile(cArray);
                }
            }
            return null;
        }
    }

    private static class StringCacheEntry {
        char[] value;
        Object cachedValue;

        StringCacheEntry(char[] cArray) {
            this.value = cArray;
            this.cachedValue = StringValue.compressValue(cArray, 0, cArray.length);
            if (this.cachedValue == null) {
                this.cachedValue = cArray;
            }
        }

        char[] getValue() {
            return this.value;
        }

        Object getCachedValue() {
            return this.cachedValue;
        }
    }

    private static class StringProfile {
        int refs;
        char[] value;

        private StringProfile(char[] cArray) {
            this.value = cArray;
        }
    }
}

