/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import com.google.common.eventbus.DeadEvent;
import com.google.common.eventbus.Subscribe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventBus {
    private static final Log LOGGER = LogFactory.getLog(EventBus.class);
    private final com.google.common.eventbus.EventBus _eventBus = new com.google.common.eventbus.EventBus();

    public EventBus() {
        this._eventBus.register((Object)new DeadEventHandler());
    }

    public void register(Object object) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("[EventBus] New registration: %s", object));
        }
        this._eventBus.register(object);
    }

    public void unregister(Object object) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("[EventBus] Unregistering: %s", object));
        }
        this._eventBus.unregister(object);
    }

    public void post(Object object) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format("[EventBus] Posting event: %s", object));
        }
        this._eventBus.post(object);
    }

    public static EventBus getInstance() {
        return Holder.INSTANCE;
    }

    private static class DeadEventHandler {
        private DeadEventHandler() {
        }

        @Subscribe
        public void logDeadEvent(DeadEvent deadEvent) {
            LOGGER.debug((Object)String.format("[EventBus] Event posted with no handlers (dead event): %s", deadEvent.getEvent()));
        }
    }

    private static class Holder {
        private static final EventBus INSTANCE = new EventBus();

        private Holder() {
        }
    }
}

