/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientAccountFile {
    private static final Log logger = LogFactory.getLog(ClientAccountFile.class);
    private static final String CLIENT_ACCOUNTS_ZIP_ENTRY = "client-accounts";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClientAccountFile(String fileName, List<ClientAccount> accounts, int accountFormat) throws IOException {
        FileOutputStream fos = null;
        try {
            File file = new File(fileName);
            fileName = file.getCanonicalPath();
            File tempFile = new File(fileName + ".incomplete");
            logger.debug((Object)("Writing client account file to: " + fileName));
            File parentDir = new File(fileName).getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            fos = new FileOutputStream(tempFile);
            ClientAccountFile.writeClientAccountsToStream(fos, accounts, accountFormat);
            IOUtils.closeQuietly(fos);
            if (file.exists()) {
                logger.debug((Object)("Deleting previous client account file: " + fileName));
                file.delete();
            }
            tempFile.renameTo(file);
            logger.debug((Object)"Completed writing client account file.");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<ClientAccount> readClientAccountFile(String fileName, int accountFormat) throws IOException {
        Vector<ClientAccount> vector;
        FileInputStream fin = null;
        try {
            File f = new File(fileName);
            fileName = f.getAbsolutePath();
            long start = System.currentTimeMillis();
            logger.debug((Object)("Loading account data from file: " + fileName));
            if (!f.exists()) {
                throw new FileNotFoundException("Cannot find client account file: " + fileName);
            }
            fin = new FileInputStream(f);
            Vector<ClientAccount> accounts = ClientAccountFile.readClientAccountsFromStream(fin, accountFormat);
            long stop = System.currentTimeMillis();
            logger.debug((Object)("Completed loading account data from file. Took: " + (stop - start) + "ms. Accounts: " + accounts.size()));
            vector = accounts;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fin);
            throw throwable;
        }
        IOUtils.closeQuietly(fin);
        return vector;
    }

    public static void writeClientAccountsToStream(OutputStream out, List<ClientAccount> accounts, int accountFormat) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(out);
        zipOut.putNextEntry(new ZipEntry(CLIENT_ACCOUNTS_ZIP_ENTRY));
        DataOutputStream dos = new DataOutputStream(zipOut);
        dos.writeInt(accountFormat);
        dos.writeInt(accounts.size());
        for (ClientAccount clientAccount : accounts) {
            ClientAccountFile.writeVectorToStream(dos, clientAccount.saveToVector(accountFormat));
        }
        dos.flush();
        zipOut.finish();
    }

    public static Vector<ClientAccount> readClientAccountsFromStream(InputStream in, int accountFormat) throws IOException {
        ZipEntry ze;
        ZipInputStream zipIn = new ZipInputStream(in);
        do {
            if ((ze = zipIn.getNextEntry()) != null) continue;
            throw new ApplicationException("Invalid client account file, and does not contain the entry: client-accounts");
        } while (!CLIENT_ACCOUNTS_ZIP_ENTRY.equals(ze.getName()));
        DataInputStream din = new DataInputStream(zipIn);
        int format = din.readInt();
        if (format != accountFormat) {
            throw new ApplicationException("Unsupported client file format: " + format + ". Expecting: " + accountFormat);
        }
        int size = din.readInt();
        Vector<ClientAccount> accounts = new Vector<ClientAccount>(size);
        Vector<Object> prototypeVector = new ClientAccount(0L).saveToVector(accountFormat);
        for (int i = 0; i < size; ++i) {
            Vector<Object> acctVector = ClientAccountFile.readVectorFromStream(din, prototypeVector);
            accounts.add(ClientAccount.loadFromVector(acctVector, accountFormat));
        }
        zipIn.closeEntry();
        return accounts;
    }

    private static Vector<Object> readVectorFromStream(DataInputStream in, Vector<Object> prototype) throws IOException {
        Vector<Object> r = new Vector<Object>(prototype.size());
        for (Object protoObj : prototype) {
            if (protoObj == null) {
                throw new IllegalArgumentException("Null prototype data not supported");
            }
            if (protoObj instanceof String) {
                r.add(in.readUTF());
                continue;
            }
            if (protoObj instanceof Integer) {
                r.add(in.readInt());
                continue;
            }
            if (protoObj instanceof Boolean) {
                r.add(in.readBoolean());
                continue;
            }
            if (protoObj instanceof Double) {
                r.add(in.readDouble());
                continue;
            }
            if (protoObj instanceof Float) {
                r.add(Float.valueOf(in.readFloat()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type to serialize: " + protoObj.getClass().getName());
        }
        return r;
    }

    private static void writeVectorToStream(DataOutputStream out, Vector<Object> data) throws IOException {
        for (Object obj : data) {
            if (obj == null) {
                throw new IllegalArgumentException("Null data not supported");
            }
            if (obj instanceof String) {
                out.writeUTF((String)obj);
                continue;
            }
            if (obj instanceof Integer) {
                out.writeInt((Integer)obj);
                continue;
            }
            if (obj instanceof Boolean) {
                out.writeBoolean((Boolean)obj);
                continue;
            }
            if (obj instanceof Double) {
                out.writeDouble((Double)obj);
                continue;
            }
            if (obj instanceof Float) {
                out.writeFloat(((Float)obj).floatValue());
                continue;
            }
            throw new IllegalArgumentException("Unsupported type to serialize: " + obj.getClass().getName());
        }
    }
}

