/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit.accounts;

import biz.papercut.pcng.client.uit.accounts.AccountIdListModel;
import biz.papercut.pcng.client.uit.accounts.AccountListTableModel;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.EnhancedTextField;
import biz.papercut.pcng.util.swing.EnterFilteringInputMap;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountList
extends JPanel
implements FocusListener {
    private static final Log logger = LogFactory.getLog(AccountList.class);
    protected static final int COL_IDX_ACCOUNT = 0;
    protected static final int COL_IDX_CODE = 1;
    protected static final int COL_IDX_PREFERED = 2;
    private static final String INDENT_SPACE = "    ";
    private static final int MAX_QUICK_FIND_LENGTH = 255;
    private static final int PREF_WIDTH = 400;
    private static final int COL_MIN_WIDTH_ACCOUNT = 100;
    private static final int COL_MAX_WIDTH_ACCOUNT = 400;
    private static final int COL_MIN_WIDTH_CODE = 100;
    private static final int COL_MAX_WIDTH_CODE = 133;
    private static final int COL_WIDTH_PREFERRED = 80;
    private static String s_lastSearch = "";
    private static boolean s_rememberLastSearch = true;
    private static long s_lastSelection = -1L;
    private JTable _table;
    private AccountListTableModel _tableModel;
    private JTextField _quickFind;
    private JCheckBox _rememberSearch;
    private boolean _dataLoaded = false;
    private boolean _showCode;

    public AccountList(boolean showCode) {
        this._showCode = showCode;
        this._tableModel = new AccountListTableModel();
        this._table = new JTable(this._tableModel);
        EnterFilteringInputMap.applyToComponent((JComponent)this._table);
        this._quickFind = this.getQuickFindTextField();
        this._rememberSearch = this.getRememberSearchComboBox();
        this.layoutComponents();
        this._rememberSearch.setSelected(s_rememberLastSearch);
        if (this._rememberSearch.isSelected()) {
            this._quickFind.setText(s_lastSearch);
        }
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ClientAccount a = AccountList.this.getSelectedAccount();
                if (a != null && !a.isDisabled()) {
                    s_lastSelection = a.getAccountId();
                }
            }
        });
        if (!this._showCode) {
            TableColumnModel colModel = this._table.getColumnModel();
            colModel.removeColumn(colModel.getColumn(1));
        }
        this.addFocusListener(this);
        this.setFocusable(true);
    }

    public void loadData(List<ClientAccount> accounts, AccountIdListModel preferedAccounts) {
        this._tableModel.loadData(accounts, preferedAccounts, this._quickFind.getText());
        this.selectLastSelectedAccount();
        this._dataLoaded = true;
    }

    private void layoutComponents() {
        this._table.setPreferredScrollableViewportSize(new Dimension(400, 50));
        this._table.setShowVerticalLines(false);
        this._table.setShowHorizontalLines(false);
        this._table.setSelectionMode(0);
        this.initColumnSizes(this._table);
        DefaultTableCellRenderer accountRenderer = new DefaultTableCellRenderer(){

            public void setValue(Object value) {
                super.setValue(value);
                if (value instanceof ClientAccount) {
                    ClientAccount ca = (ClientAccount)value;
                    this.setEnabled(!ca.isDisabled());
                    if (ca.isParent()) {
                        this.setText(ca.getParentName());
                    } else {
                        this.setText(AccountList.INDENT_SPACE + ca.getSubName());
                    }
                }
            }
        };
        TableColumn accountCol = this._table.getColumn(Messages.getString(this.getClass(), (String)"Common.HEADING_ACCOUNT", (String[])new String[0]));
        accountCol.setCellRenderer(accountRenderer);
        JScrollPane scrollPane = new JScrollPane(this._table);
        scrollPane.getViewport().setBackground(this._table.getBackground());
        scrollPane.setOpaque(false);
        this._rememberSearch.setOpaque(false);
        FormLayout layout = new FormLayout("pref, 4dlu, pref:grow, 4dlu, pref", "pref, 4dlu, pref:grow");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        builder.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        builder.addLabel(Messages.getString(this.getClass(), (String)"AccountList.SEARCH", (String[])new String[0]), cc.xy(1, 1));
        builder.add((Component)this._quickFind, cc.xy(3, 1));
        builder.add((Component)this._rememberSearch, cc.xy(5, 1));
        builder.add((Component)scrollPane, cc.xyw(1, 3, 5, CellConstraints.FILL, CellConstraints.FILL));
    }

    private void selectLastSelectedAccount() {
        AccountListTableModel model = (AccountListTableModel)this._table.getModel();
        int rowCount = model.getRowCount();
        if (rowCount < 1) {
            return;
        }
        if (s_lastSelection > 0L) {
            for (int i = 0; i < rowCount; ++i) {
                ClientAccount ca = (ClientAccount)model.getValueAt(i, 0);
                if (ca == null || ca.getAccountId() != s_lastSelection) continue;
                this._table.changeSelection(i, 0, false, false);
                return;
            }
        }
        this.selectBestMatchingAccount(this._quickFind.getText());
    }

    public void selectPersonalAccount() {
        s_lastSelection = -1L;
        this.selectLastSelectedAccount();
    }

    public void selectAccountByName(String name) {
        logger.debug((Object)("Attempting to pre-select account by name: " + name));
        AccountListTableModel model = (AccountListTableModel)this._table.getModel();
        int rowCount = model.getRowCount();
        if (rowCount < 1) {
            return;
        }
        if (StringUtils.isNotBlank((String)name)) {
            for (int i = 0; i < rowCount; ++i) {
                ClientAccount ca = (ClientAccount)model.getValueAt(i, 0);
                if (ca == null || !ca.getDisplayName().equals(name)) continue;
                logger.debug((Object)"Found matching account, and will preselect");
                this._table.changeSelection(i, 0, false, false);
                return;
            }
        }
    }

    private void selectBestMatchingAccount(String filter) {
        int MAX_SCAN = 25;
        int firstActive = -1;
        int firstMatch = -1;
        int firstLeadingMatch = -1;
        filter = StringUtils.trimToEmpty((String)filter).toLowerCase();
        AccountListTableModel model = (AccountListTableModel)this._table.getModel();
        if (model.getRowCount() < 1) {
            return;
        }
        int max = model.getRowCount() > 25 ? 25 : model.getRowCount();
        for (int i = 0; i < max; ++i) {
            ClientAccount ca = (ClientAccount)model.getValueAt(i, 0);
            if (ca == null || ca.isDisabled()) continue;
            if (firstActive == -1) {
                firstActive = i;
            }
            if (firstMatch == -1 && this.accountMatchesFilter(ca, filter, false)) {
                firstMatch = i;
            }
            if (!this.accountMatchesFilter(ca, filter, true)) continue;
            firstLeadingMatch = i;
            break;
        }
        if (firstLeadingMatch >= 0) {
            this._table.changeSelection(firstLeadingMatch, 0, false, false);
        } else if (firstMatch >= 0) {
            this._table.changeSelection(firstMatch, 0, false, false);
        } else if (firstActive >= 0) {
            this._table.changeSelection(firstActive, 0, false, false);
        } else {
            this._table.changeSelection(0, 0, false, false);
        }
    }

    private boolean accountMatchesFilter(ClientAccount ca, String filter, boolean leadingOnly) {
        if (ca == null) {
            return false;
        }
        if (leadingOnly) {
            return ca.getParentName().toLowerCase().startsWith(filter) || ca.getSubName().toLowerCase().startsWith(filter) || ca.getFullPin().toLowerCase().startsWith(filter);
        }
        return ca.getParentName().toLowerCase().indexOf(filter) >= 0 || ca.getSubName().toLowerCase().indexOf(filter) >= 0 || ca.getFullPin().toLowerCase().indexOf(filter) >= 0;
    }

    public ClientAccount getSelectedAccount() {
        AccountListTableModel model = (AccountListTableModel)this._table.getModel();
        int row = this._table.getSelectedRow();
        if (row >= 0) {
            return (ClientAccount)model.getValueAt(row, 0);
        }
        return null;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this._table.getSelectionModel().addListSelectionListener(listener);
    }

    public void initColumnSizes(JTable table) {
        table.getColumnModel().getColumn(0).setMinWidth(100);
        table.getColumnModel().getColumn(0).setMaxWidth(400);
        if (this._showCode) {
            table.getColumnModel().getColumn(1).setMinWidth(100);
            table.getColumnModel().getColumn(1).setMaxWidth(133);
        } else {
            table.getColumnModel().getColumn(1).setMinWidth(0);
            table.getColumnModel().getColumn(1).setMaxWidth(0);
        }
        table.getColumnModel().getColumn(2).setMinWidth(80);
        table.getColumnModel().getColumn(2).setMaxWidth(80);
        table.getColumnModel().getColumn(2).setResizable(false);
    }

    private JCheckBox getRememberSearchComboBox() {
        if (this._rememberSearch == null) {
            this._rememberSearch = new JCheckBox(Messages.getString(this.getClass(), (String)"AccountList.REMEMBER", (String[])new String[0]));
            this._rememberSearch.setSelected(s_rememberLastSearch);
            this._rememberSearch.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    s_rememberLastSearch = AccountList.this._rememberSearch.isSelected();
                }
            });
        }
        return this._rememberSearch;
    }

    private JTextField getQuickFindTextField() {
        if (this._quickFind == null) {
            this._quickFind = new EnhancedTextField(255);
            DocumentListener documentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    this.doChange(e);
                }

                public void removeUpdate(DocumentEvent e) {
                    this.doChange(e);
                }

                public void changedUpdate(DocumentEvent e) {
                    this.doChange(e);
                }

                private void doChange(DocumentEvent e) {
                    if (!AccountList.this._dataLoaded) {
                        return;
                    }
                    TableModel model = AccountList.this._table.getModel();
                    if (model instanceof AccountListTableModel) {
                        ((AccountListTableModel)model).applyFilter(AccountList.this._quickFind.getText());
                        AccountList.this.selectBestMatchingAccount(AccountList.this._quickFind.getText());
                    }
                    s_lastSearch = AccountList.this._quickFind.getText();
                }
            };
            this._quickFind.getDocument().addDocumentListener(documentListener);
        }
        return this._quickFind;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this._quickFind.requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

