/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.TextFileSignerException;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public final class TextFileSigner {
    private static final int KEY_SIZE = 1024;
    private static final String ALGORITHM = "RSA";
    private static final String SIGNATURE_TYPE = "MD5withRSA";

    private TextFileSigner() {
    }

    public static EncodedKeyPair generateKeyPair() {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TextFileSignerException(e.getMessage());
        }
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String privateKeyString = new String(Base64.encodeBase64((byte[])privateKey.getEncoded()));
        String publicKeyString = new String(Base64.encodeBase64((byte[])publicKey.getEncoded()));
        return new EncodedKeyPair(publicKeyString, privateKeyString);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void signFile(String privateKey, File inFile, File outFile) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(inFile);
            fos = new FileOutputStream(outFile);
            TextFileSigner.signStream(privateKey, fis, fos);
        }
        catch (TextFileSignerException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new TextFileSignerException(e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fis);
        IOUtils.closeQuietly(fos);
    }

    public static void signStream(String privateKey, InputStream inStream, OutputStream outStream) {
        try {
            SignedFile signedFile = new SignedFile();
            signedFile.setBody(inStream);
            byte[] privateKeyBytes = Base64.decodeBase64((byte[])privateKey.getBytes());
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PrivateKey key = keyFactory.generatePrivate(privateKeySpec);
            Signature signer = Signature.getInstance(SIGNATURE_TYPE);
            signer.initSign(key);
            byte[] body = signedFile.getBodyAsByteArray();
            signer.update(body);
            byte[] theSig = signer.sign();
            String sig = new String(Base64.encodeBase64((byte[])theSig));
            signedFile.setSignature(sig);
            signedFile.save(outStream);
        }
        catch (Exception e) {
            throw new TextFileSignerException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignedFile loadSignedFile(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        try {
            SignedFile signedFile = TextFileSigner.loadSignedStream(fin);
            return signedFile;
        }
        finally {
            IOUtils.closeQuietly(fin);
        }
    }

    public static SignedFile loadSignedStream(InputStream in) throws IOException {
        SignedFile signedFile = new SignedFile();
        signedFile.load(in);
        return signedFile;
    }

    public static boolean verifySignedFile(String publicKey, SignedFile signedFile) {
        try {
            byte[] publicKeyBytes = Base64.decodeBase64((byte[])publicKey.getBytes());
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PublicKey key = keyFactory.generatePublic(publicKeySpec);
            Signature signer = Signature.getInstance(SIGNATURE_TYPE);
            signer.initVerify(key);
            byte[] body = signedFile.getBodyAsByteArray();
            signer.update(body);
            boolean signatureVerified = false;
            try {
                byte[] theSig = Base64.decodeBase64((byte[])signedFile.getSignature().getBytes());
                signatureVerified = signer.verify(theSig);
            }
            catch (SignatureException signError) {
                signatureVerified = false;
            }
            return signatureVerified;
        }
        catch (Exception e) {
            throw new TextFileSignerException(e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("generate-keys")) {
            EncodedKeyPair kp = TextFileSigner.generateKeyPair();
            System.out.println("Public Key: " + kp.getPublicKey());
            System.out.println("Private Key: " + kp.getPrivateKey());
        }
    }

    public static class SignedFile {
        private static final String CHAR_ENCODING = "ISO-8859-1";
        private static final String SIG_PREFIX = "signature=";
        private static final String END_OF_LINE = "\r\n";
        private String _signature;
        private List<String> _lines;

        protected SignedFile() {
        }

        protected void load(InputStream is) throws IOException {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(is, CHAR_ENCODING));
            this._lines = new ArrayList<String>();
            this._signature = "";
            while ((line = in.readLine()) != null) {
                if (line.startsWith(SIG_PREFIX)) {
                    int equalPos = line.indexOf(61);
                    this._signature = line.substring(equalPos + 1, line.length());
                    continue;
                }
                this._lines.add(line);
            }
        }

        protected void save(OutputStream os) throws IOException {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os, CHAR_ENCODING));
            for (String line : this._lines) {
                out.write(line);
                out.write(END_OF_LINE);
            }
            if (this._signature.length() > 0) {
                out.write(SIG_PREFIX);
                out.write(this._signature);
                out.write(END_OF_LINE);
            }
            out.flush();
        }

        public String getSignature() {
            return this._signature;
        }

        public void setSignature(String sig) {
            this._signature = sig;
        }

        public InputStream getBody() {
            return new ByteArrayInputStream(this.getBodyAsByteArray());
        }

        public void setBody(InputStream in) {
            BufferedReader br;
            try {
                br = new BufferedReader(new InputStreamReader(in, CHAR_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                throw new ApplicationException("Unknown character encoding: ISO-8859-1", e);
            }
            this._lines = new ArrayList<String>();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    this._lines.add(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read from input stream");
            }
        }

        public byte[] getBodyAsByteArray() {
            if (this._lines == null) {
                return new byte[0];
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, CHAR_ENCODING));
                for (String line : this._lines) {
                    br.write(line);
                    br.write(END_OF_LINE);
                }
                br.close();
            }
            catch (IOException e) {
                throw new ApplicationException("Unable to write to byte array");
            }
            return outputStream.toByteArray();
        }
    }

    public static class EncodedKeyPair {
        private String _publicKey;
        private String _privateKey;

        protected EncodedKeyPair(String publicKey, String privateKey) {
            this._publicKey = publicKey;
            this._privateKey = privateKey;
        }

        public String getPrivateKey() {
            return this._privateKey;
        }

        public String getPublicKey() {
            return this._publicKey;
        }
    }
}

