/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.common.ClientAction;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.util.swing.DialogUtils;
import biz.papercut.pcng.util.swing.SwingUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.xmlrpc.XmlRpc;

public class StressTester {
    private static final Log logger = LogFactory.getLog(StressTester.class);
    private static final int BALANCE_CHECK_WAIT_MS = 1000;

    public static void main(String[] args) {
        Properties logProps = new Properties();
        String LOG_FILE_NAME = "stress-test.log";
        logProps.setProperty("log4j.appender.log", "org.apache.log4j.FileAppender");
        logProps.setProperty("log4j.appender.log.File", new File(LOG_FILE_NAME).getAbsolutePath());
        logProps.setProperty("log4j.appender.log.layout", "org.apache.log4j.PatternLayout");
        logProps.setProperty("log4j.appender.log.layout.ConversionPattern", "%d{ISO8601} %5p %c{1}:%L - %m%n");
        logProps.setProperty("log4j.rootLogger", "off, log");
        if (args[args.length - 1].equalsIgnoreCase("debug")) {
            logProps.setProperty("log4j.logger.biz.papercut", "debug");
        } else {
            logProps.setProperty("log4j.logger.biz.papercut", "info");
        }
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((Properties)logProps);
        try {
            if (args.length < 3) {
                logger.error((Object)"Usage: --stress-test ServerIP NumThreads  [TestUserPrefix] [ServerPort] [TimeoutSecs]  [\"Debug\"]");
            }
            final String serverIP = args[1];
            final int numThreads = Integer.parseInt(args[2]);
            String tempPrefix = "testuser";
            if (args.length > 3) {
                tempPrefix = args[3];
            }
            String prefix = tempPrefix;
            int tempServerPort = 9191;
            if (args.length > 4) {
                tempServerPort = Integer.parseInt(args[4]);
            }
            final int serverPort = tempServerPort;
            int tempTimeoutSecs = 90;
            if (args.length > 5) {
                tempTimeoutSecs = Integer.parseInt(args[5]);
            }
            final int timeoutSecs = tempTimeoutSecs;
            System.getProperties().put("http.proxySet", "false");
            System.getProperties().put("http.proxyHost", "");
            System.getProperties().put("http.proxyPort", "");
            try {
                SwingUtils.setupSystemLookAndFeel();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DialogUtils.showInformationMessageDialog(null, (String)"Stress Tester", (String)("The stress tester is in progress.\nSimulating " + numThreads + " client connections.\n" + "Press OK to end test."));
                        System.exit(0);
                    }
                });
            }
            catch (Exception e) {
                // empty catch block
            }
            final AtomicLong counter = new AtomicLong();
            XmlRpc.setMaxThreads((int)((int)((double)numThreads * 1.2)));
            for (int i = 0; i < numThreads; ++i) {
                final String userName = prefix + i;
                Thread.sleep(50L);
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            logger.info((Object)("Creating server connection: " + userName + " to " + serverIP + ":" + serverPort));
                            ServerConnection connection = new ServerConnection(serverIP, serverIP, serverPort, timeoutSecs, false, false);
                            connection.setUserName(userName);
                            while (true) {
                                try {
                                    block13: while (true) {
                                        logger.debug((Object)("calling getPendingActions (user=" + userName + ")"));
                                        long startTime = System.currentTimeMillis();
                                        long requestsMade = counter.incrementAndGet();
                                        if (requestsMade % 100L == 0L) {
                                            logger.info((Object)("requests made: " + requestsMade));
                                        }
                                        List<ClientAction> actions = connection.getPendingActions(timeoutSecs);
                                        logger.debug((Object)("called getPendingActions (user=" + userName + "): " + actions.size() + " actions [" + (System.currentTimeMillis() - startTime) + "ms]"));
                                        Iterator<ClientAction> i$ = actions.iterator();
                                        while (true) {
                                            if (!i$.hasNext()) continue block13;
                                            ClientAction action = i$.next();
                                            switch (action) {
                                                case UserMessages: {
                                                    Vector<String> messages = connection.getPendingMessages();
                                                    logger.debug((Object)("got " + messages.size() + " messages"));
                                                    break;
                                                }
                                                case PrintJobs: {
                                                    List<ClientPrintJob> jobs = connection.getPendingPrintJobs();
                                                    logger.debug((Object)("got " + jobs.size() + " jobs"));
                                                    break;
                                                }
                                                case BalanceUpdate: {
                                                    Thread.sleep(1000L);
                                                    String balance = connection.getUserBalance(userName);
                                                    logger.debug((Object)("got balance " + balance));
                                                    break;
                                                }
                                                case AuthenticationExpired: {
                                                    logger.debug((Object)"got auth expired");
                                                    break;
                                                }
                                                case AuthenticationRequested: {
                                                    logger.debug((Object)"got auth requested");
                                                    break;
                                                }
                                                case DialogRequest: {
                                                    logger.debug((Object)"got dialog request");
                                                }
                                            }
                                        }
                                        break;
                                    }
                                }
                                catch (Exception e) {
                                    logger.error((Object)("Server connection failed: " + userName + " to " + serverIP + ":" + serverPort), (Throwable)e);
                                    Thread.sleep(30000L);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable t) {
                            logger.error((Object)("Server connection failed: " + userName + " to " + serverIP + ":" + serverPort), t);
                            return;
                        }
                    }
                }).start();
            }
        }
        catch (Throwable t) {
            logger.error((Object)t);
        }
    }
}

