/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AuthPanel;
import biz.papercut.pcng.client.uit.ClientConfigFile;
import biz.papercut.pcng.client.uit.MSWindowsUtils;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.common.ClientAuthResponse;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.BrowserLinkLabel;
import biz.papercut.pcng.util.swing.DialogBannerPanel;
import biz.papercut.pcng.util.swing.DialogUtils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthDialog
extends JDialog {
    private static final Log logger = LogFactory.getLog(AuthDialog.class);
    private static final Color DEFAULT_LINK_COLOR = new Color(Integer.parseInt("808080", 16));
    private JButton _okButton;
    private JButton _cancelButton;
    private AuthPanel _authPanel;
    private UserClientConfig _clientConfig;
    private UserClientFrame _uit;
    private ServerConnection _serverConnection;

    public AuthDialog(UserClientFrame uit, UserClientConfig clientConfig, ServerConnection connection) {
        super(uit, AuthDialog.format("login", new String[0]), true);
        this._uit = uit;
        this.setServerConnection(connection);
        this.setClientConfig(clientConfig);
        logger.debug((Object)"Displaying auth dialog");
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        ClientGlobalConfigFromServer confFromServer = this.getClientConfig().getServerGlobalConfig();
        DialogBannerPanel panel = UserClientUtils.getStandardDialogBanner(AuthDialog.format("login", new String[0]), AuthDialog.format("description", new String[0]), confFromServer);
        contentPanel.add((Component)panel, "North");
        this._authPanel = new AuthPanel(clientConfig, connection.getGlobalConfig());
        contentPanel.add((Component)this._authPanel, "Center");
        this._okButton = new JButton(AuthDialog.format("ok", new String[0]));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AuthDialog.this.okButtonPressed();
            }
        });
        this._cancelButton = new JButton(AuthDialog.format("cancel", new String[0]));
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AuthDialog.this.cancelButtonPressed();
            }
        });
        FormLayout layout = new FormLayout("pref:grow", "pref");
        JPanel south = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, buttonPanel);
        builder.setDefaultDialogBorder();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this._okButton, (JButton)this._cancelButton));
        south.add((Component)buttonPanel, "Center");
        if (confFromServer.isShowRegisterLink()) {
            BrowserLinkLabel registerLink = new BrowserLinkLabel(confFromServer.getRegisterLinkText(), clientConfig.getRegisterPageURL());
            registerLink.setForeground(DEFAULT_LINK_COLOR);
            registerLink.setHorizontalAlignment(4);
            registerLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
            south.add((Component)registerLink, "South");
        }
        contentPanel.add((Component)south, "South");
        this.setContentPane(contentPanel);
        this.getRootPane().setDefaultButton(this._okButton);
        this.pack();
        final int minWidth = (int)this.getSize().getWidth();
        final int minHeight = (int)this.getSize().getHeight();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                AuthDialog.this.setSize(new Dimension(Math.max(minWidth, AuthDialog.this.getWidth()), Math.max(minHeight, AuthDialog.this.getHeight())));
            }
        });
        this.setLocationRelativeTo(null);
        MSWindowsUtils.addWindowListenerToBringWindowToFrontOnOpen(this);
        DialogUtils.forceRepaintAfterOpened((Window)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void okButtonPressed() {
        logger.debug((Object)"OK pressed");
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String username = this._authPanel.getUsername();
            String password = this._authPanel.getPassword();
            int ttl = this._authPanel.getTimeToLiveSeconds();
            ClientAuthResponse response = this._authPanel.isAuthByIdNumber() ? this.getServerConnection().authenticateUserByIdNumber(username, password, ttl) : this.getServerConnection().authenticateUser(username, password, ttl);
            if (response.isSuccess()) {
                username = response.getRealName();
                this.getClientConfig().loginUser(username);
                this._uit.updateDisplay();
                if (ttl == -2 && StringUtils.isNotBlank((String)response.getAuthCookie())) {
                    ClientConfigFile.saveUserAuthCookie(response.getAuthCookie());
                }
                this.closeDialog();
            } else {
                String error = response.getErrorMessage();
                if (this._authPanel.isAuthByIdNumber()) {
                    error = this._authPanel.isRequirePin() ? (StringUtils.isBlank((String)password) ? AuthDialog.format("pin-required", new String[0]) : AuthDialog.format("invalid-id-pin", new String[0])) : AuthDialog.format("invalid-id", new String[0]);
                }
                DialogUtils.showInformationMessageDialog((Component)this, (String)AuthDialog.format("error", new String[0]), (String)error);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to call authentication method: " + e.getMessage()), (Throwable)e);
            DialogUtils.showInformationMessageDialog((Component)this, (String)AuthDialog.format("error", new String[0]), (String)e.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static String format(String key, String ... args) {
        String fullKey = "AuthDialog." + key;
        return Messages.getString(AuthDialog.class, (String)fullKey, (String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelButtonPressed() {
        logger.debug((Object)"Cancel pressed");
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this._uit.doLogout();
            this.closeDialog();
        }
        catch (Exception e) {
            logger.error((Object)"Unable to call clear authentication method.", (Throwable)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    public ServerConnection getServerConnection() {
        return this._serverConnection;
    }

    public void setServerConnection(ServerConnection serverConnection) {
        this._serverConnection = serverConnection;
    }

    public UserClientConfig getClientConfig() {
        return this._clientConfig;
    }

    public void setClientConfig(UserClientConfig clientConfig) {
        this._clientConfig = clientConfig;
    }
}

