/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.io.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NameAlias {
    private static final Log logger = LogFactory.getLog(NameAlias.class);
    private static int CHECK_FOR_CHANGES_PERIOD_MS = 10000;
    private Map<String, String> _cachedMapping = null;
    private long _lastModifiedTime = -1L;
    private long _lastCheckTime = -1L;
    private File _mappingFile;
    private boolean _caseSensitive;

    public NameAlias(File mappingFile, boolean caseSensitive) {
        this._mappingFile = mappingFile;
        this._caseSensitive = caseSensitive;
        this.loadMappingDataIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMappingDataIfRequired() {
        if (this._lastCheckTime + (long)CHECK_FOR_CHANGES_PERIOD_MS > System.currentTimeMillis()) {
            return;
        }
        this._lastCheckTime = System.currentTimeMillis();
        if (!this._mappingFile.exists()) {
            this._cachedMapping = null;
            return;
        }
        long lastModified = this._mappingFile.lastModified();
        if (lastModified <= this._lastModifiedTime) {
            return;
        }
        logger.debug((Object)"Mapping file modified, so need to reload.");
        FileInputStream fstream = null;
        InputStream in = null;
        BufferedReader br = null;
        try {
            String strLine;
            this._cachedMapping = new HashMap<String, String>();
            fstream = new FileInputStream(this._mappingFile);
            br = new BufferedReader(new InputStreamReader(fstream));
            while ((strLine = br.readLine()) != null) {
                if (strLine.startsWith("#") || StringUtils.isBlank((String)strLine)) continue;
                String[] temp = strLine.split("\t|=|:");
                if (temp.length >= 2) {
                    String alias = StringUtils.trimToNull((String)temp[0]);
                    String name = StringUtils.trimToNull((String)temp[1]);
                    if (alias == null || name == null) continue;
                    if (!this._caseSensitive) {
                        alias = alias.toLowerCase();
                    }
                    this._cachedMapping.put(alias, name);
                    continue;
                }
                logger.warn((Object)("Bad data in alias file: " + strLine));
            }
            this._lastModifiedTime = lastModified;
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Strange IO error raised when trying to load name aliases file: " + this._mappingFile.getAbsolutePath()), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(fstream);
                throw throwable;
            }
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(fstream);
        }
        IOUtils.closeQuietly(br);
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(fstream);
    }

    public synchronized String lookupNameByAlias(String alias) {
        this.loadMappingDataIfRequired();
        if (this._cachedMapping == null) {
            return null;
        }
        if (!this._caseSensitive) {
            return this._cachedMapping.get(alias.toLowerCase());
        }
        return this._cachedMapping.get(alias);
    }
}

