/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import biz.papercut.pcng.util.swing.SwingUtils;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class GlassImage
extends JComponent {
    private BufferedImage _bufferedImage = null;
    private volatile float _alpha = 1.0f;

    public GlassImage(URL imageResource) {
        this.loadImageResource(imageResource);
    }

    public GlassImage(URL imageResource, float alpha) {
        this.loadImageResource(imageResource);
        this.setAlpha(alpha);
    }

    public void loadImageResource(URL imageResource) {
        try {
            this._bufferedImage = SwingUtils.toCompatibleImage(ImageIO.read(imageResource));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid image resource");
        }
    }

    public void setAlpha(float alpha) {
        this._alpha = alpha;
        this.repaint();
    }

    public float getAlpha() {
        return this._alpha;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setComposite(AlphaComposite.getInstance(3, this._alpha));
        g2d.drawImage((Image)this._bufferedImage, 0, 0, null);
    }
}

