/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.io;

import biz.papercut.pcng.util.io.LineHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class IOUtils {
    private static final Logger logger = Logger.getLogger(IOUtils.class);
    private static final int BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    public static long getFreeSpace(String dir) {
        File dirFile = new File(dir);
        if (!dirFile.isDirectory()) {
            logger.debug((Object)("Cannot determine free space. '" + dir + "' is not a directory."));
            return -1L;
        }
        Method m = null;
        try {
            m = File.class.getMethod("getFreeSpace", new Class[0]);
        }
        catch (Exception e) {
            logger.debug((Object)("No free space method, probably non-1.6 VM. " + e.getMessage()));
            return -1L;
        }
        try {
            Long freeBytes = (Long)m.invoke((Object)dirFile, new Object[0]);
            return freeBytes;
        }
        catch (Exception e) {
            logger.debug((Object)("Error determining free space: " + e.getMessage()), (Throwable)e);
            return -1L;
        }
    }

    public static void copy(InputStream input, OutputStream output, boolean closeWhenExhausted) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        if (closeWhenExhausted) {
            try {
                output.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static void copy(Reader input, Writer output, boolean closeWhenExhausted) throws IOException {
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        if (closeWhenExhausted) {
            try {
                output.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static void copyLines(Reader input, LineHandler lineHandler) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(input);
        while (null != (line = reader.readLine())) {
            lineHandler.handleLine(line);
        }
    }

    public static void closeQuietly(InputStream s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(Reader r) {
        try {
            if (r != null) {
                r.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer w) {
        try {
            if (w != null) {
                w.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ServerSocket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static String toString(InputStream input, String charset) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input, (Writer)sw, charset);
        return sw.toString();
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IOUtils.copy(in, output);
    }

    public static void copy(InputStream input, Writer output, String charset) throws IOException {
        InputStreamReader in = new InputStreamReader(input, charset);
        IOUtils.copy(in, output);
    }

    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static void closeQuietly(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean deleteRecursive(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                IOUtils.deleteRecursive(files[i]);
            }
        }
        return file.delete();
    }

    public static long getFileSize(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            throw new IllegalArgumentException("getFileSize() cannot accept a blank filename.");
        }
        File f = new File(fileName);
        if (!f.exists() || !f.isFile()) {
            return -1L;
        }
        return f.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeObjectToFile(File saveFile, Serializable obj) throws IOException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(saveFile);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
            oos.flush();
            fos.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(oos);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(oos);
        IOUtils.closeQuietly(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserializeObjectFromFile(File loadFile) throws IOException, ClassNotFoundException {
        Object object;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(loadFile);
            ois = new ObjectInputStream(fis);
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(ois);
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly(ois);
        IOUtils.closeQuietly(fis);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, Charset charset) throws IOException {
        String string;
        FileInputStream fin = null;
        try {
            int charsRead;
            fin = new FileInputStream(file);
            InputStreamReader r = new InputStreamReader((InputStream)fin, charset);
            char[] cbuf = new char[2048];
            StringBuilder sb = new StringBuilder(cbuf.length);
            while ((charsRead = r.read(cbuf)) >= 0) {
                sb.append(cbuf, 0, charsRead);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fin);
            throw throwable;
        }
        IOUtils.closeQuietly(fin);
        return string;
    }
}

