/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AuthHandler;
import biz.papercut.pcng.client.uit.ClientConfigFile;
import biz.papercut.pcng.client.uit.ClientController;
import biz.papercut.pcng.client.uit.MSWindowsUtils;
import biz.papercut.pcng.client.uit.MacUtils;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClient;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.io.IOUtils;
import biz.papercut.pcng.util.swing.BrowserLinkLabel;
import biz.papercut.pcng.util.swing.DialogUtils;
import biz.papercut.pcng.util.swing.FadeImage;
import biz.papercut.pcng.util.swing.SwingUtils;
import biz.papercut.pcng.util.swing.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserClientFrame
extends JFrame
implements ClientController.BalanceUpdateListener,
ClientController.MessageListener {
    private static final Logger logger = Logger.getLogger(UserClientFrame.class);
    private static final int DEFAULT_CREDIT_LABLE_SIZE = 28;
    private static final int SMALL_CREDIT_LABLE_SIZE = 18;
    private static final float WINDOW_IN_FOCUS_ALPHA = 0.9f;
    private static final float WINDOW_OUT_FOCUS_ALPHA = 0.8f;
    private static final Color DEFAULT_TEXT_COLOR;
    private static final Color DEFAULT_LINK_COLOR;
    private static final Color DEFAULT_LINK_HOVER_COLOR;
    private static final float DEFAULT_LOGO_ALPHA = 0.8f;
    private ServerConnection _serverConnection;
    private boolean _checkingBalance = false;
    private boolean _initialisationComplete = false;
    private UserClientConfig _config;
    private boolean _popupDialogIsDisplayed = false;
    private JComponent _logoImage;
    private JLabel _creditLabel;
    private BrowserLinkLabel _userPageLink;
    private BrowserLinkLabel _linkLabel;
    private JLabel _refreshImage;
    private JPopupMenu _popupMenu;
    private JMenu _actionsMenu;
    private TrayIcon _trayIcon = null;

    public void preConnectionInit(UserClientConfig config) {
        logger.debug((Object)"Pre-connect initialization");
        this.setIconImage(this.createImageIcon("images/client-icon-64.png").getImage());
        this.buildMenus();
        if (!config.isDisableTaskTray()) {
            this.setupTaskTray();
        }
        if (SystemUtils.IS_OS_MAC_OSX && this._actionsMenu != null) {
            JMenuBar mb = new JMenuBar();
            mb.add(this._actionsMenu);
            this.setJMenuBar(mb);
        }
        this.getContentPane().addMouseListener(new PopupListener());
        this._creditLabel = new JLabel();
        this._refreshImage = new JLabel();
        this._creditLabel.addMouseListener(new PopupListener());
        logger.debug((Object)"Setting Swing layout");
        this.getContentPane().setLayout(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (UserClientFrame.this.hasTaskTray()) {
                    UserClientFrame.this.setState(1);
                    UserClientFrame.this.setVisible(false);
                } else {
                    UserClientFrame.this.setState(1);
                }
            }
        });
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        URL logoURL = this.getClass().getResource("images/client-icon-64.png");
        File customLogoFile = UserClientUtils.getCustomIconImage();
        if (customLogoFile != null) {
            logger.debug((Object)("Using custom icon image: " + customLogoFile.getAbsolutePath()));
            try {
                logoURL = customLogoFile.toURL();
            }
            catch (MalformedURLException e) {
                logger.error((Object)"Unable to load custom image)", (Throwable)e);
            }
        }
        this._logoImage = SystemUtils.IS_JAVA_1_4 ? new JLabel(new ImageIcon(logoURL)) : new FadeImage(logoURL, 0.0f);
        this.getContentPane().add(this._logoImage);
        this._logoImage.setBounds(5, 5, 64, 64);
        this._refreshImage.setIcon(this.createImageIcon("images/refresh.png"));
        this._refreshImage.setToolTipText(UserClientFrame.getMessage("refresh-balance"));
        this._refreshImage.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                UserClientFrame.this.refreshImageMouseClicked(evt);
            }
        });
        this.getContentPane().add(this._refreshImage);
        this._refreshImage.setBounds(195, 5, 20, 20);
        logger.debug((Object)"Pre-connect initialization complete");
    }

    public void completeInitialisation(ServerConnection connection, UserClientConfig config) {
        ClientGlobalConfigFromServer serverConf;
        logger.debug((Object)"Completing initialisation");
        this._config = config;
        this._serverConnection = connection;
        this.setWindowTitle();
        if (this._config.getBackgroundColor() >= 0) {
            this.getContentPane().setBackground(new Color(this._config.getBackgroundColor()));
        }
        Color textColor = DEFAULT_TEXT_COLOR;
        if (this._config.getTextColor() >= 0) {
            textColor = new Color(this._config.getTextColor());
        }
        Color linkColor = DEFAULT_LINK_COLOR;
        Color linkHoverColor = DEFAULT_LINK_HOVER_COLOR;
        if (this._config.getLinkColor() >= 0) {
            linkColor = new Color(this._config.getLinkColor());
        }
        if (this._config.getLinkHoverColor() >= 0) {
            linkHoverColor = new Color(this._config.getLinkHoverColor());
        }
        if ((serverConf = this._config.getServerGlobalConfig()).isShowLink() && StringUtils.isNotBlank((String)serverConf.getLinkURL()) && StringUtils.isNotBlank((String)serverConf.getLinkText())) {
            this._linkLabel = new BrowserLinkLabel(serverConf.getLinkText(), serverConf.getLinkURL());
            this._linkLabel.setForeground(linkColor);
            this._linkLabel.setHighlightedColor(linkHoverColor);
            this._linkLabel.setHorizontalAlignment(4);
            this.getContentPane().add((Component)this._linkLabel);
            this._linkLabel.setBounds(70, 5, 120, 20);
        }
        if (serverConf.isShowDetailsLink() && StringUtils.isNotBlank((String)this._config.getUserPageURL())) {
            this._userPageLink = new BrowserLinkLabel(UserClientFrame.getMessage("user-details"));
            this.setUserDetailsURLLink();
            this._userPageLink.setForeground(linkColor);
            this._userPageLink.setHighlightedColor(linkHoverColor);
            this._userPageLink.setHorizontalAlignment(4);
            this.getContentPane().add((Component)this._userPageLink);
            this._userPageLink.setBounds(90, 57, 120, 15);
        }
        this._creditLabel.setFont(new Font(this._creditLabel.getFont().getName(), 0, 28));
        this._creditLabel.setHorizontalAlignment(2);
        this._creditLabel.setText("");
        this.getContentPane().add(this._creditLabel);
        this._creditLabel.setForeground(textColor);
        this._creditLabel.setBounds(75, 15, 140, 50);
        if (this._config.getBackgroundColor() < 0) {
            JLabel backgroundImage = new JLabel();
            backgroundImage.setIcon(this.createImageIcon("images/client-background.png"));
            this.getContentPane().add(backgroundImage);
            backgroundImage.setBounds(0, 0, 267, 117);
        }
        this.setWindowPositionFromConfig(this._config);
        this.doBalanceRefresh();
        this.buildMenus();
        if (!this._config.isDisableGUIEffects()) {
            this.addWindowFocusListener(new WindowFocusListener(){

                public void windowGainedFocus(WindowEvent e) {
                    if (UserClientFrame.this.isVisible()) {
                        SwingUtils.setWindowAlpha((Window)UserClientFrame.this, (float)0.9f);
                    }
                }

                public void windowLostFocus(WindowEvent e) {
                    if (UserClientFrame.this.isVisible()) {
                        SwingUtils.setWindowAlpha((Window)UserClientFrame.this, (float)0.8f);
                    }
                }
            });
        }
        if (this._config.isStartMinimised() || this._config.getServerGlobalConfig().isStartMinimized() || !this._config.getServerUserConfig().isShowBalance()) {
            if (this.hasTaskTray()) {
                this.setVisible(false);
            } else {
                int state = this.getExtendedState();
                this.setVisible(true);
                this.setExtendedState(state |= 1);
            }
        } else {
            this.setVisible(true);
            this.toFront();
        }
        if (this._logoImage instanceof FadeImage) {
            FadeImage fadeImage = (FadeImage)this._logoImage;
            if (this._config.isDisableGUIEffects()) {
                fadeImage.setAlpha(0.8f);
            } else {
                fadeImage.fadeToAlpha(0.8f, 750L);
            }
        }
        DialogUtils.forceRepaintAfterOpened((Window)this);
        this._initialisationComplete = true;
    }

    private void setWindowPositionFromConfig(UserClientConfig config) {
        String[] coords;
        int width = 224;
        int height = 105;
        try {
            if (SystemUtils.IS_OS_WINDOWS && Toolkit.getDefaultToolkit().getScreenResolution() >= 120) {
                height += 12;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        String windowPos = StringUtils.trimToNull((String)config.getWindowPosition());
        if (windowPos == null) {
            windowPos = "top-right";
        }
        int xIn = 0;
        int yIn = 0;
        boolean usingCoords = false;
        if (windowPos.startsWith("XY") && windowPos.indexOf(44) > 0 && (coords = windowPos.split("\\s*,\\s*")).length > 0) {
            try {
                xIn = Integer.parseInt(coords[0].substring(2));
                yIn = Integer.parseInt(coords[1]);
                usingCoords = true;
            }
            catch (NumberFormatException nfe) {
                xIn = 0;
                yIn = 0;
            }
        }
        if (!usingCoords) {
            if (windowPos.equalsIgnoreCase("top-left")) {
                xIn = 40;
                yIn = 40;
            } else if (windowPos.equalsIgnoreCase("top-right")) {
                xIn = -40;
                yIn = 40;
            } else if (windowPos.equalsIgnoreCase("bottom-left")) {
                xIn = 40;
                yIn = -40;
            } else if (windowPos.equalsIgnoreCase("bottom-right")) {
                xIn = -40;
                yIn = -40;
            } else {
                xIn = -40;
                yIn = 40;
            }
        }
        int x = xIn > 0 ? xIn : screenSize.width - 224 - -xIn;
        int y = yIn > 0 ? yIn : screenSize.height - height - -yIn;
        this.setBounds(x, y, 224, height);
    }

    public void updateDisplay() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UserClientFrame.this.setWindowTitle();
                UserClientFrame.this.setUserDetailsURLLink();
                UserClientFrame.this.doBalanceRefresh();
                UserClientFrame.this.buildMenus();
            }
        });
    }

    private void setWindowTitle() {
        if (StringUtils.isBlank((String)this._config.getWindowTitle())) {
            this.setTitle(UserClientFrame.format("balance-for", this._config.getDisplayUserName()));
        } else {
            this.setTitle(MessageFormat.format(this._config.getWindowTitle(), this._config.getDisplayUserName()));
        }
    }

    private void setUserDetailsURLLink() {
        if (this._userPageLink == null) {
            return;
        }
        String pageURL = this._config.getUserPageURL();
        String usernameEncoded = null;
        try {
            usernameEncoded = URLEncoder.encode(this._config.getDisplayUserName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            usernameEncoded = this._config.getDisplayUserName();
        }
        pageURL = pageURL + "?username=" + usernameEncoded;
        this._userPageLink.setLinkURL(pageURL);
    }

    private void setupTaskTray() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            logger.debug((Object)"Not on Windows, do not try to initialise the task tray.");
            return;
        }
        try {
            logger.debug((Object)"Setting up task tray");
            ImageIcon image = this.createImageIcon("images/client-icon-64.png");
            this._trayIcon = new TrayIcon((Icon)image);
            this._trayIcon.setPopupMenu(this._popupMenu);
            this._trayIcon.setToolTip(UserClientFrame.getMessage("connecting"));
            this._trayIcon.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (UserClientFrame.this._config != null && UserClientFrame.this._config.getServerUserConfig().isShowBalance()) {
                        UserClientFrame.this.makeVisible();
                    }
                }
            });
            SystemTray tray = SystemTray.getDefaultSystemTray();
            tray.addTrayIcon(this._trayIcon);
        }
        catch (Throwable t) {
            logger.error((Object)"Error setting up task tray", t);
            this._trayIcon = null;
        }
    }

    private void buildMenus() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Building popup menu. Config: " + this._config));
        }
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu("Tray Icon Menu");
        }
        this._popupMenu.removeAll();
        JMenuItem openItem = new JMenuItem(UserClientFrame.getMessage("open"));
        openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UserClientFrame.this.makeVisible();
            }
        });
        openItem.setOpaque(true);
        if (this._config != null && this._config.getServerUserConfig().isShowBalance()) {
            logger.debug((Object)"Show balance, add open item");
            this._popupMenu.add(openItem);
        }
        JMenuItem logout = null;
        JMenuItem login = null;
        if (this._config != null) {
            if (this._config.isCurrentlyAuthenticated()) {
                logger.debug((Object)"Currently authenticated, add logout menu");
                logout = new JMenuItem(UserClientFrame.getMessage("logout"));
                logout.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        UserClientFrame.this.doLogout();
                    }
                });
                logout.setOpaque(true);
                this._popupMenu.add(logout);
            }
            if (this._config.getServerUserConfig().isUnauthenticatedUser()) {
                logger.debug((Object)"Unauthenticated, add login as menu");
                login = new JMenuItem(UserClientFrame.getMessage("login-as"));
                login.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        ClientConfigFile.deleteUserAuthCookie();
                        UserClientFrame.this.doLogin();
                    }
                });
                login.setOpaque(true);
                this._popupMenu.add(login);
            }
        }
        if (this._popupMenu.getComponents().length > 0) {
            this._popupMenu.addSeparator();
        }
        JMenuItem exitItem = new JMenuItem(UserClientFrame.getMessage("exit"));
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                logger.debug((Object)"User select 'Exit'");
                UserClientFrame.this.exitIfAllowed();
            }
        });
        exitItem.setOpaque(true);
        this._popupMenu.add(exitItem);
        if (SystemUtils.IS_OS_MAC_OSX) {
            logger.debug((Object)"On Mac, add actions menu");
            if (this._actionsMenu == null) {
                this._actionsMenu = new JMenu(UserClientFrame.getMessage("actions"));
            }
            this._actionsMenu.removeAll();
            if (logout != null) {
                logger.debug((Object)"Mac: add logout menu");
                this._actionsMenu.add(logout);
            }
            if (login != null) {
                logger.debug((Object)"Mac: add login menu");
                this._actionsMenu.add(login);
            }
            this._actionsMenu.addSeparator();
            this._actionsMenu.add(exitItem);
        }
    }

    public void doLogout() {
        logger.debug((Object)"clearing authentication");
        this._serverConnection.clearAuthentication();
        this._config.logoutUser();
        ClientConfigFile.deleteUserAuthCookie();
        this.updateDisplay();
    }

    private void doLogin() {
        AuthHandler handler = new AuthHandler(this, this._serverConnection, this._config);
        handler.doAuthRequest();
    }

    private void makeVisible() {
        if (this._initialisationComplete && !this._popupDialogIsDisplayed) {
            if (this._logoImage instanceof FadeImage && !this.isVisible()) {
                FadeImage fadeImage = (FadeImage)this._logoImage;
                if (this._config.isDisableGUIEffects()) {
                    fadeImage.setAlpha(0.8f);
                } else {
                    fadeImage.setAlpha(0.0f);
                    fadeImage.fadeToAlpha(0.8f, 750L);
                }
            }
            this.setState(0);
            this.setVisible(true);
            this.toFront();
        }
    }

    private boolean hasTaskTray() {
        return this._trayIcon != null;
    }

    public void setTaskTrayToolTip(String text) {
        if (this._trayIcon != null) {
            this._trayIcon.setToolTip(text);
        }
    }

    @Override
    public void newMessages(final List<String> messages, final UserClientConfig config) {
        this.invokeAndWait(new Runnable(){

            public void run() {
                UserClientFrame.this.displayMessages(messages, config);
            }
        });
    }

    @Override
    public void newBalance(final String balance) {
        this.invokeAndWait(new Runnable(){

            public void run() {
                UserClientFrame.this.setCreditText(balance);
            }
        });
    }

    private void invokeAndWait(Runnable doRun) {
        try {
            SwingUtilities.invokeAndWait(doRun);
        }
        catch (Exception e) {
            logger.error((Object)("Error occurred: " + e.getMessage()), (Throwable)e);
        }
    }

    private void displayMessages(List<String> msgs, UserClientConfig config) {
        for (String msg : msgs) {
            if (MSWindowsUtils.isWindows8OrHigher()) {
                MSWindowsUtils.sendWindows8Message(msg);
            }
            if (this.hasTaskTray() && !config.isDisableTaskTrayBalloonTips()) {
                logger.debug((Object)"Display message using task tray.");
                this._trayIcon.displayMessage(UserClientFrame.getMessage("message"), msg, 0);
                continue;
            }
            if (SystemUtils.IS_OS_MAC && MacUtils.growlNotify(msg)) {
                logger.debug((Object)"Message successfully displayed using growl.");
                continue;
            }
            logger.debug((Object)"Display message via popup dialog");
            DialogUtils.setAlwaysOnTop((Window)this, (boolean)true);
            DialogUtils.showInformationMessageDialog((Component)this, (String)UserClientFrame.getMessage("message"), (String)msg);
            DialogUtils.setAlwaysOnTop((Window)this, (boolean)false);
            logger.debug((Object)"Display message via popup dialog completed");
        }
    }

    protected void refreshImageMouseClicked(MouseEvent evt) {
        this.doBalanceRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBalanceRefresh() {
        if (!this._config.getServerUserConfig().isShowBalance()) {
            this.setCreditText("");
            return;
        }
        UserClientFrame userClientFrame = this;
        synchronized (userClientFrame) {
            if (this._checkingBalance) {
                return;
            }
            this._checkingBalance = true;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        SwingWorker<Object> worker = new SwingWorker<Object>(){
            private String _creditValue;
            private boolean _errorOccurred = false;

            public Object construct() {
                try {
                    this._creditValue = UserClientFrame.this.getServerConnection().getUserBalance(UserClientFrame.this._config.getDisplayUserName());
                    if (StringUtils.isBlank((String)this._creditValue)) {
                        this._errorOccurred = true;
                    }
                }
                catch (Exception e) {
                    this._errorOccurred = true;
                    logger.error((Object)"Error getting balance", (Throwable)e);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished() {
                try {
                    UserClientFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                    if (!this._errorOccurred && this._creditValue != null) {
                        UserClientFrame.this.setCreditText(this._creditValue);
                        this._creditValue = null;
                    }
                }
                finally {
                    UserClientFrame userClientFrame = UserClientFrame.this;
                    synchronized (userClientFrame) {
                        UserClientFrame.this._checkingBalance = false;
                    }
                }
            }
        };
        worker.start();
    }

    private void setCreditText(String creditValue) {
        if (this._config.getServerUserConfig().isShowBalance()) {
            String currentValue = this._creditLabel.getText();
            Font currentFont = this._creditLabel.getFont();
            logger.debug((Object)("Balance label font: " + currentFont.getFontName()));
            this._creditLabel.setHorizontalAlignment(creditValue.length() <= 3 ? 0 : 2);
            DialogUtils.setTextHandlingFontDisplayProblems((JLabel)this._creditLabel, (String)creditValue);
            this._creditLabel.setText(creditValue);
            Font standardFont = new Font(this._creditLabel.getFont().getName(), 0, 28);
            FontMetrics standardMetrics = this._creditLabel.getFontMetrics(standardFont);
            if (standardMetrics.stringWidth(creditValue) > this._creditLabel.getWidth()) {
                if (this._creditLabel.getFont().getSize() == 28) {
                    this._creditLabel.setFont(new Font(this._creditLabel.getFont().getName(), 0, 18));
                }
            } else if (this._creditLabel.getFont().getSize() == 18) {
                this._creditLabel.setFont(new Font(this._creditLabel.getFont().getName(), 0, 28));
            }
            this._creditLabel.setToolTipText(creditValue);
            this.animateCreditChange(currentValue, creditValue);
        } else {
            logger.debug((Object)"User is not configured to display balance, so display '-----'. User may not be allowed to charge to a personal balance or balance display is disabled.");
            this._creditLabel.setText("-----");
            this._creditLabel.setHorizontalAlignment(0);
        }
        String toolTipText = ApplicationInfo.getInstance().getApplicationName() + "\n" + this._config.getDisplayUserName();
        if (this._config.getServerUserConfig().isShowBalance()) {
            toolTipText = toolTipText + ": " + creditValue;
        }
        this.setTaskTrayToolTip(toolTipText);
    }

    private void animateCreditChange(String from, String to) {
        double fromNumber = 0.0;
        double toNumber = 0.0;
        String toNumberPortion = "";
        try {
            Pattern p = Pattern.compile("[\\-\\d,\\s]+[\\.]\\d\\d");
            Matcher fromMatcher = p.matcher(StringUtils.trimToEmpty((String)from));
            Matcher toMatcher = p.matcher(StringUtils.trimToEmpty((String)to));
            if (toMatcher.find()) {
                toNumberPortion = toMatcher.group();
                NumberFormat nf = DecimalFormat.getInstance();
                toNumber = nf.parse(toMatcher.group()).doubleValue();
                if (fromMatcher.find()) {
                    fromNumber = nf.parse(fromMatcher.group()).doubleValue();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this._config.isDisableGUIEffects() && StringUtils.isNotBlank((String)toNumberPortion) && Math.abs(toNumber - fromNumber) > 0.01) {
            final double toNumberFinal = toNumber;
            final double fromNumberFinal = fromNumber;
            final String toStringFinal = to;
            final String toNumberPortionFinal = toNumberPortion;
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        logger.debug((Object)("Animating balance change from: " + fromNumberFinal + " to " + toNumberFinal));
                        NumberFormat currencyFormat = DecimalFormat.getInstance();
                        currencyFormat.setMaximumFractionDigits(2);
                        currencyFormat.setMinimumFractionDigits(2);
                        int steps = 10;
                        int maxDelay = 150;
                        int minDelay = 50;
                        for (int i = 0; i < 10; ++i) {
                            double value = (toNumberFinal - fromNumberFinal) * (double)i / 10.0 + fromNumberFinal;
                            if (Math.abs(toNumberFinal - fromNumberFinal) > 10.0) {
                                value = Math.round(value);
                            }
                            String valueFormatted = currencyFormat.format(value);
                            String output = toStringFinal.replace(toNumberPortionFinal, valueFormatted);
                            UserClientFrame.this.updateCreditLabelOnEventThread(output);
                            int delay = -100 * i / 10 + 150;
                            Thread.sleep(delay);
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error animating balance change to: " + toNumberFinal + " - " + e.getMessage()), (Throwable)e);
                    }
                    finally {
                        UserClientFrame.this.updateCreditLabelOnEventThread(toStringFinal);
                    }
                    logger.debug((Object)"Completed balance change animation");
                }
            });
            t.setDaemon(true);
            t.start();
        } else {
            logger.debug((Object)"Update balance without animation.");
            this._creditLabel.setText(to);
        }
    }

    private void updateCreditLabelOnEventThread(final String value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._creditLabel.setText(value);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UserClientFrame.this._creditLabel.setText(value);
                }
            });
        }
    }

    private static String format(String key, String ... args) {
        String fullKey = "UserClientFrame." + key;
        return Messages.getString(UserClient.class, (String)fullKey, (String[])args);
    }

    private static String getMessage(String key) {
        String fullKey = "UserClientFrame." + key;
        return Messages.getString(UserClient.class, (String)fullKey, (String[])null);
    }

    private ImageIcon createImageIcon(String path) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        logger.debug((Object)("Unable to load image: " + path));
        return null;
    }

    private ServerConnection getServerConnection() {
        return this._serverConnection;
    }

    public void shutdown() {
        logger.debug((Object)"Shutdown");
        this.setVisible(false);
        this.dispose();
        if (this._serverConnection != null) {
            try {
                this._serverConnection.clearAuthentication();
            }
            catch (Exception e) {
                logger.error((Object)"Unable to clear authentication on shutdown.", (Throwable)e);
            }
        }
        if (SystemUtils.IS_OS_WINDOWS && this._trayIcon != null) {
            try {
                SystemTray tray = SystemTray.getDefaultSystemTray();
                tray.removeTrayIcon(this._trayIcon);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable t) {
                logger.error((Object)("Error shutting down task tray: " + t.getMessage()), t);
            }
        }
        System.exit(0);
    }

    public void exitIfAllowed() {
        if (this._initialisationComplete && (this._config.getServerUserConfig().isClientRequiredToPrint() || this._config.isDisallowExit())) {
            DialogUtils.showInformationMessageDialog((Component)this, (String)UserClientFrame.getMessage("warning"), (String)UserClientFrame.getMessage("close-warning"));
        } else {
            this.shutdown();
        }
    }

    public boolean isPopupDialogIsDisplayed() {
        return this._popupDialogIsDisplayed;
    }

    public void setPopupDialogIsDisplayed(boolean popupIsDisplayed) {
        if (popupIsDisplayed && !DialogUtils.hasSetAlwaysOnTop() && !this.isVisible()) {
            this.makeVisible();
        }
        DialogUtils.setAlwaysOnTop((Window)this, (boolean)popupIsDisplayed);
        this._popupDialogIsDisplayed = popupIsDisplayed;
    }

    private static Color parseRGBColor(String rgbHexString, Color defaultColor) {
        int color;
        try {
            color = Integer.parseInt(rgbHexString, 16);
        }
        catch (Exception e) {
            logger.debug((Object)("Could not parse RGB color value: " + rgbHexString), (Throwable)e);
            return defaultColor;
        }
        if (color < 0 || color > 0xFFFFFF) {
            logger.debug((Object)("Could not parse RGB color value.  Outside valid range: " + rgbHexString));
            return defaultColor;
        }
        return new Color(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String TEXT_COLOR = "text-color";
        String LINK_COLOR = "link-color";
        String LINK_HOVER_COLOR = "link-hover-color";
        Properties uiDefaults = new Properties();
        InputStream in = null;
        try {
            in = UserClientFrame.class.getResourceAsStream("ui-defaults.properties");
            uiDefaults.load(in);
        }
        catch (IOException e) {
            logger.debug((Object)("Unable to load ui-defaults.properties. " + e.getMessage()), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        DEFAULT_TEXT_COLOR = UserClientFrame.parseRGBColor(uiDefaults.getProperty("text-color"), new Color(2784846));
        DEFAULT_LINK_COLOR = UserClientFrame.parseRGBColor(uiDefaults.getProperty("link-color"), new Color(699737));
        DEFAULT_LINK_HOVER_COLOR = UserClientFrame.parseRGBColor(uiDefaults.getProperty("link-hover-color"), new Color(351537));
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                UserClientFrame.this._popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

