/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.NetPermission;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.Permission;

public abstract class Authenticator {
    private static Authenticator theAuthenticator;
    private String requestingHost;
    private InetAddress requestingSite;
    private int requestingPort;
    private String requestingProtocol;
    private String requestingPrompt;
    private String requestingScheme;
    private URL requestingURL;
    private RequestorType requestingAuthType;

    private void reset() {
        this.requestingHost = null;
        this.requestingSite = null;
        this.requestingPort = -1;
        this.requestingProtocol = null;
        this.requestingPrompt = null;
        this.requestingScheme = null;
        this.requestingURL = null;
        this.requestingAuthType = RequestorType.SERVER;
    }

    public static synchronized void setDefault(Authenticator authenticator) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            NetPermission netPermission = new NetPermission("setDefaultAuthenticator");
            securityManager.checkPermission(netPermission);
        }
        theAuthenticator = authenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordAuthentication requestPasswordAuthentication(InetAddress inetAddress, int n, String string, String string2, String string3) {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new NetPermission("requestPasswordAuthentication");
            securityManager.checkPermission((Permission)object);
        }
        if ((object = theAuthenticator) == null) {
            return null;
        }
        Object object2 = object;
        synchronized (object2) {
            super.reset();
            ((Authenticator)object).requestingSite = inetAddress;
            ((Authenticator)object).requestingPort = n;
            ((Authenticator)object).requestingProtocol = string;
            ((Authenticator)object).requestingPrompt = string2;
            ((Authenticator)object).requestingScheme = string3;
            return ((Authenticator)object).getPasswordAuthentication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordAuthentication requestPasswordAuthentication(String string, InetAddress inetAddress, int n, String string2, String string3, String string4) {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new NetPermission("requestPasswordAuthentication");
            securityManager.checkPermission((Permission)object);
        }
        if ((object = theAuthenticator) == null) {
            return null;
        }
        Object object2 = object;
        synchronized (object2) {
            super.reset();
            ((Authenticator)object).requestingHost = string;
            ((Authenticator)object).requestingSite = inetAddress;
            ((Authenticator)object).requestingPort = n;
            ((Authenticator)object).requestingProtocol = string2;
            ((Authenticator)object).requestingPrompt = string3;
            ((Authenticator)object).requestingScheme = string4;
            return ((Authenticator)object).getPasswordAuthentication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PasswordAuthentication requestPasswordAuthentication(String string, InetAddress inetAddress, int n, String string2, String string3, String string4, URL uRL, RequestorType requestorType) {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new NetPermission("requestPasswordAuthentication");
            securityManager.checkPermission((Permission)object);
        }
        if ((object = theAuthenticator) == null) {
            return null;
        }
        Object object2 = object;
        synchronized (object2) {
            super.reset();
            ((Authenticator)object).requestingHost = string;
            ((Authenticator)object).requestingSite = inetAddress;
            ((Authenticator)object).requestingPort = n;
            ((Authenticator)object).requestingProtocol = string2;
            ((Authenticator)object).requestingPrompt = string3;
            ((Authenticator)object).requestingScheme = string4;
            ((Authenticator)object).requestingURL = uRL;
            ((Authenticator)object).requestingAuthType = requestorType;
            return ((Authenticator)object).getPasswordAuthentication();
        }
    }

    protected final String getRequestingHost() {
        return this.requestingHost;
    }

    protected final InetAddress getRequestingSite() {
        return this.requestingSite;
    }

    protected final int getRequestingPort() {
        return this.requestingPort;
    }

    protected final String getRequestingProtocol() {
        return this.requestingProtocol;
    }

    protected final String getRequestingPrompt() {
        return this.requestingPrompt;
    }

    protected final String getRequestingScheme() {
        return this.requestingScheme;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        return null;
    }

    protected URL getRequestingURL() {
        return this.requestingURL;
    }

    protected RequestorType getRequestorType() {
        return this.requestingAuthType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestorType {
        PROXY,
        SERVER;

    }
}

