/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocaleUtils {
    private LocaleUtils() {
    }

    @CheckForNull
    public static Locale getLocaleFromString(String loc) {
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].toString().toLowerCase().equals(loc.toLowerCase())) continue;
            return locales[i];
        }
        if ("eu_ES".equalsIgnoreCase(loc)) {
            return new Locale("eu", "ES");
        }
        if ("gl_ES".equalsIgnoreCase(loc)) {
            return new Locale("gl", "ES");
        }
        return null;
    }

    public static List<Locale> getLocaleListFromString(String values) {
        ArrayList<Locale> l = new ArrayList<Locale>();
        if (StringUtils.isNotEmpty((String)values)) {
            String[] additional;
            for (String s : additional = values.split("\\s*,\\s*")) {
                Locale loc = LocaleUtils.getLocaleFromString(s);
                if (loc == null) continue;
                l.add(loc);
            }
        }
        return l;
    }

    public static String upperCaseUSLocale(String s) {
        if (s == null) {
            return null;
        }
        return s.toUpperCase(Locale.US);
    }

    public static String lowerCaseUSLocale(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase(Locale.US);
    }
}

