/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common.client.dialogrequest;

import biz.papercut.pcng.common.client.dialogrequest.ChoiceDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.HTMLFormDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.TextDialogRequest;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogProtocolHelper {
    private static final Log logger = LogFactory.getLog(DialogProtocolHelper.class);

    public static ClientDialogRequest parseFromHashtable(Hashtable<String, Object> data) {
        String typeName = (String)data.get("type");
        if (typeName == null) {
            throw new IllegalArgumentException("Unknown dialog type. Not 'type' specified.");
        }
        if ("MessageDialog".equals(typeName)) {
            return new MessageDialogRequest(data);
        }
        if ("TextDialog".equals(typeName)) {
            return new TextDialogRequest(data);
        }
        if ("ChoiceDialog".equals(typeName)) {
            return new ChoiceDialogRequest(data);
        }
        if ("HTMLFormDialog".equals(typeName)) {
            return new HTMLFormDialogRequest(data);
        }
        logger.debug((Object)("Unknown dialog type: " + typeName + ". Data: " + data));
        return null;
    }

    public static String getResponsePrintEventID(Hashtable<String, Object> data) {
        return (String)data.get("printEventID");
    }

    public static String getResponseUniqueID(Hashtable<String, Object> data) {
        return (String)data.get("uniqueID");
    }

    private DialogProtocolHelper() {
    }
}

