/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit.accounts;

import biz.papercut.pcng.client.uit.accounts.AccountIdListModel;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.util.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AccountListTableModel
extends AbstractTableModel {
    private List<ClientAccount> _allAccounts = null;
    private List<ClientAccount> _filteredAccounts;
    private AccountIdListModel _preferedAccounts;

    public AccountListTableModel() {
        ClientAccount ca = new ClientAccount(1L);
        ca.setDisabled(true);
        ca.setParentName(Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]));
        this._filteredAccounts = new ArrayList<ClientAccount>(1);
        this._filteredAccounts.add(ca);
        this._preferedAccounts = new AccountIdListModel("");
    }

    public void loadData(List<ClientAccount> accounts, AccountIdListModel preferedAccounts, String initalFilter) {
        this._allAccounts = accounts;
        this.sortAccounts(this._allAccounts);
        String currentParent = "";
        ArrayList<ClientAccount> placeHolderParents = new ArrayList<ClientAccount>();
        for (ClientAccount ca : this._allAccounts) {
            if (ca.isParent()) {
                currentParent = ca.getParentName();
                continue;
            }
            if (ca.getParentName().equals(currentParent)) continue;
            ClientAccount placeHolder = new ClientAccount(-9999L);
            placeHolder.setDisabled(true);
            placeHolder.setParentName(ca.getParentName());
            placeHolder.setSubName("");
            placeHolderParents.add(placeHolder);
            currentParent = ca.getParentName();
        }
        if (placeHolderParents.size() > 0) {
            this._allAccounts.addAll(placeHolderParents);
            this.sortAccounts(this._allAccounts);
        }
        this._preferedAccounts = preferedAccounts;
        this.buildFilteredAccounts(initalFilter);
        this.fireTableDataChanged();
    }

    private void sortAccounts(List<ClientAccount> accounts) {
        Collections.sort(accounts, new Comparator<ClientAccount>(){

            @Override
            public int compare(ClientAccount c1, ClientAccount c2) {
                if (c1.getAccountId() == -1L) {
                    return -1;
                }
                if (c2.getAccountId() == -1L) {
                    return 1;
                }
                int r = c1.getParentName().compareToIgnoreCase(c2.getParentName());
                if (r == 0) {
                    r = c1.getSubName().compareToIgnoreCase(c2.getSubName());
                }
                return r;
            }
        });
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_ACCOUNT", (String[])new String[0]);
        }
        if (column == 1) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_CODE", (String[])new String[0]);
        }
        if (column == 2) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_PREFERRED", (String[])new String[0]);
        }
        throw new IllegalArgumentException("Unexpcted column index");
    }

    public void applyFilter(String filter) {
        this.buildFilteredAccounts(filter);
        this.fireTableDataChanged();
    }

    private void buildFilteredAccounts(String filter) {
        if (this._allAccounts == null) {
            return;
        }
        ClientAccount currentParent = null;
        boolean currentParentMatched = true;
        String filterLC = StringUtils.trimToEmpty((String)filter).toLowerCase();
        if (StringUtils.isEmpty((String)filterLC)) {
            this._filteredAccounts = this._allAccounts;
        } else {
            this._filteredAccounts = new ArrayList<ClientAccount>();
            for (ClientAccount ca : this._allAccounts) {
                if (ca.isParent()) {
                    currentParent = ca;
                    if (this.accountMatchesFilter(ca, filterLC)) {
                        this._filteredAccounts.add(ca);
                        currentParentMatched = true;
                        continue;
                    }
                    currentParentMatched = false;
                    continue;
                }
                if (currentParentMatched) {
                    this._filteredAccounts.add(ca);
                    continue;
                }
                if (!this.accountMatchesFilter(ca, filterLC)) continue;
                if (currentParent != null) {
                    this._filteredAccounts.add(currentParent);
                    currentParent = null;
                }
                this._filteredAccounts.add(ca);
            }
        }
    }

    private boolean accountMatchesFilter(ClientAccount ca, String filter) {
        return ca.getParentName().toLowerCase().indexOf(filter) >= 0 || ca.getSubName().toLowerCase().indexOf(filter) >= 0 || ca.getFullPin().toLowerCase().indexOf(filter) >= 0;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        if (this._filteredAccounts == null) {
            return 1;
        }
        return this._filteredAccounts.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (this._filteredAccounts == null) {
                return Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]);
            }
            return this._filteredAccounts.get(rowIndex);
        }
        if (columnIndex == 1) {
            if (this._filteredAccounts == null) {
                return "";
            }
            ClientAccount ca = this._filteredAccounts.get(rowIndex);
            return ca.getFullPin();
        }
        if (columnIndex == 2) {
            if (this._filteredAccounts == null) {
                return false;
            }
            Long accountID = this._filteredAccounts.get(rowIndex).getAccountId();
            return this._preferedAccounts.contains(accountID);
        }
        throw new IllegalArgumentException("unexpected column index");
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (this._filteredAccounts == null) {
            return;
        }
        if (col == 2) {
            Long accountID = this._filteredAccounts.get(row).getAccountId();
            boolean b = (Boolean)value;
            if (b) {
                if (!this._preferedAccounts.contains(accountID)) {
                    this._preferedAccounts.add(accountID);
                }
            } else if (this._preferedAccounts.contains(accountID)) {
                this._preferedAccounts.remove(accountID);
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }
}

