/*
 * Decompiled with CFR 0.152.
 */
package org.javagalician.java6.text.spi;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.spi.NumberFormatProvider;
import java.util.Arrays;
import java.util.Locale;
import org.javagalician.java6.constants.Locales;
import org.javagalician.java6.text.GalicianDecimalFormatSymbols;

public final class GalicianNumberFormatProvider
extends NumberFormatProvider {
    @Override
    public NumberFormat getCurrencyInstance(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            NumberFormat format = NumberFormat.getCurrencyInstance(Locales.CASTILIAN);
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setDecimalFormatSymbols(new GalicianDecimalFormatSymbols());
            }
            return format;
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    @Override
    public NumberFormat getIntegerInstance(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            NumberFormat format = NumberFormat.getIntegerInstance(Locales.CASTILIAN);
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setDecimalFormatSymbols(new GalicianDecimalFormatSymbols());
            }
            return format;
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    @Override
    public NumberFormat getNumberInstance(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            NumberFormat format = NumberFormat.getNumberInstance(Locales.CASTILIAN);
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setDecimalFormatSymbols(new GalicianDecimalFormatSymbols());
            }
            return format;
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    @Override
    public NumberFormat getPercentInstance(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            NumberFormat format = NumberFormat.getPercentInstance(Locales.CASTILIAN);
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setDecimalFormatSymbols(new GalicianDecimalFormatSymbols());
            }
            return format;
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    @Override
    public Locale[] getAvailableLocales() {
        return Locales.GALICIAN_ARRAY;
    }
}

