/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.misc;

import edu.stanford.ejalbert.launching.misc.UnixBrowser;
import java.io.IOException;

class StandardUnixBrowser
implements UnixBrowser {
    private String browserName;
    private String browserArgName;
    private static final String REMOTE_PARAMETER = "-remote";
    private static final String OPEN_PARAMETER_START = "openURL(";
    private static final String OPEN_PARAMETER_END = ")";
    static final StandardUnixBrowser NETSCAPE = new StandardUnixBrowser("Netscape", "netscape");
    static final StandardUnixBrowser MOZILLA = new StandardUnixBrowser("Mozilla", "mozilla");
    static final StandardUnixBrowser FIREFOX = new StandardUnixBrowser("FireFox", "firefox");
    static final StandardUnixBrowser MOZILLA_FIREFOX = new StandardUnixBrowser("FireFox", "mozilla-firefox");
    static final StandardUnixBrowser KONQUEROR = new StandardUnixBrowser("Konqueror", "konqueror");
    static final StandardUnixBrowser OPERA = new StandardUnixBrowser("Opera", "opera");

    private StandardUnixBrowser(String browserName, String browserArgName) {
        this.browserArgName = browserArgName;
        this.browserName = browserName;
    }

    public String toString() {
        return this.browserName;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public String[] getArgsForOpenBrowser(String urlString) {
        return new String[]{this.browserArgName, REMOTE_PARAMETER, OPEN_PARAMETER_START + urlString + OPEN_PARAMETER_END};
    }

    public String[] getArgsForStartingBrowser(String urlString) {
        return new String[]{this.browserArgName, urlString};
    }

    public boolean isBrowserAvailable() {
        boolean isAvailable = false;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"which", this.browserArgName});
            int exitCode = process.waitFor();
            isAvailable = exitCode == 0;
        }
        catch (IOException ex) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return isAvailable;
    }
}

