/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.ktab.KeyTab;
import sun.security.krb5.internal.ktab.KeyTabEntry;

public class Ktab {
    KeyTab table;
    char action;
    String name;
    String principal;
    char[] password = null;

    public static void main(String[] stringArray) {
        Ktab ktab = new Ktab();
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("-help")) {
            ktab.printHelp();
            System.exit(0);
        } else if (stringArray == null || stringArray.length == 0) {
            ktab.action = (char)108;
        } else {
            ktab.processArgs(stringArray);
        }
        try {
            if (ktab.name == null) {
                ktab.table = KeyTab.getInstance();
                if (ktab.table == null) {
                    if (ktab.action == 'a') {
                        ktab.table = KeyTab.create();
                    } else {
                        System.out.println("No default key table exists.");
                        System.exit(-1);
                    }
                }
            } else {
                if (ktab.action != 'a' && !new File(ktab.name).exists()) {
                    System.out.println("Key table " + ktab.name + " does not exist.");
                    System.exit(-1);
                } else {
                    ktab.table = KeyTab.getInstance(ktab.name);
                }
                if (ktab.table == null) {
                    if (ktab.action == 'a') {
                        ktab.table = KeyTab.create(ktab.name);
                    } else {
                        System.out.println("The format of key table " + ktab.name + " is incorrect.");
                        System.exit(-1);
                    }
                }
            }
        }
        catch (RealmException realmException) {
            System.err.println("Error loading key table.");
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("Error loading key table.");
            System.exit(-1);
        }
        switch (ktab.action) {
            case 'l': {
                ktab.listKt();
                break;
            }
            case 'a': {
                ktab.addEntry();
                break;
            }
            case 'd': {
                ktab.deleteEntry();
                break;
            }
            default: {
                ktab.printHelp();
                System.exit(-1);
            }
        }
    }

    void processArgs(String[] stringArray) {
        Character c = null;
        block6: for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 2 && stringArray[i].startsWith("-")) {
                c = new Character(stringArray[i].charAt(1));
            } else {
                this.printHelp();
                System.exit(-1);
            }
            switch (c.charValue()) {
                case 'L': 
                case 'l': {
                    this.action = (char)108;
                    continue block6;
                }
                case 'A': 
                case 'a': {
                    this.action = (char)97;
                    if (++i < stringArray.length && !stringArray[i].startsWith("-")) {
                        this.principal = stringArray[i];
                    } else {
                        System.out.println("Please specify the principal name after -a option.");
                        this.printHelp();
                        System.exit(-1);
                    }
                    if (i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                        this.password = stringArray[i + 1].toCharArray();
                        ++i;
                        continue block6;
                    }
                    this.password = null;
                    continue block6;
                }
                case 'D': 
                case 'd': {
                    this.action = (char)100;
                    if (++i < stringArray.length && !stringArray[i].startsWith("-")) {
                        this.principal = stringArray[i];
                        continue block6;
                    }
                    System.out.println("Please specify the principalname of the entry you want to  delete after -d option.");
                    this.printHelp();
                    System.exit(-1);
                    continue block6;
                }
                case 'K': 
                case 'k': {
                    if (++i < stringArray.length && !stringArray[i].startsWith("-")) {
                        if (stringArray[i].length() >= 5 && stringArray[i].substring(0, 5).equalsIgnoreCase("FILE:")) {
                            this.name = stringArray[i].substring(5);
                            continue block6;
                        }
                        this.name = stringArray[i];
                        continue block6;
                    }
                    System.out.println("Please specify the keytab file name and location after -k option");
                    this.printHelp();
                    System.exit(-1);
                    continue block6;
                }
                default: {
                    this.printHelp();
                    System.exit(-1);
                }
            }
        }
    }

    void addEntry() {
        PrincipalName principalName = null;
        try {
            principalName = new PrincipalName(this.principal);
            if (principalName.getRealm() == null) {
                principalName.setRealm(Config.getInstance().getDefaultRealm());
            }
        }
        catch (KrbException krbException) {
            System.err.println("Failed to add " + this.principal + " to keytab.");
            krbException.printStackTrace();
            System.exit(-1);
        }
        if (this.password == null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Password for " + principalName.toString() + ":");
                System.out.flush();
                this.password = bufferedReader.readLine().toCharArray();
            }
            catch (IOException iOException) {
                System.err.println("Failed to read the password.");
                iOException.printStackTrace();
                System.exit(-1);
            }
        }
        try {
            this.table.addEntry(principalName, this.password);
            Arrays.fill(this.password, '0');
            this.table.save();
            System.out.println("Done!");
            Ktab ktab = this;
            System.out.println("Service key for " + this.principal + " is saved in " + ktab.table.tabName());
        }
        catch (KrbException krbException) {
            System.err.println("Failed to add " + this.principal + " to keytab.");
            krbException.printStackTrace();
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("Failed to save new entry.");
            iOException.printStackTrace();
            System.exit(-1);
        }
    }

    void listKt() {
        Ktab ktab = this;
        System.out.println("Keytab name: " + ktab.table.tabName());
        KeyTabEntry[] keyTabEntryArray = this.table.getEntries();
        if (keyTabEntryArray != null && keyTabEntryArray.length > 0) {
            System.out.println("KVNO    Principal");
            for (int i = 0; i < keyTabEntryArray.length; ++i) {
                int n = keyTabEntryArray[i].getKey().getKeyVersionNumber();
                String string = keyTabEntryArray[i].getService().toString();
                if (i == 0) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int j = 0; j < 9 + string.length(); ++j) {
                        stringBuffer.append("-");
                    }
                    System.out.println(stringBuffer.toString());
                }
                System.out.println("  " + n + "     " + string);
            }
        } else {
            System.out.println("0 entry.");
        }
    }

    void deleteEntry() {
        PrincipalName principalName = null;
        try {
            principalName = new PrincipalName(this.principal);
            if (principalName.getRealm() == null) {
                principalName.setRealm(Config.getInstance().getDefaultRealm());
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            Ktab ktab = this;
            System.out.print("Are you sure you want to  delete service key for " + principalName.toString() + " in " + ktab.table.tabName() + "?(Y/N) :");
            System.out.flush();
            String string = bufferedReader.readLine();
            if (!string.equalsIgnoreCase("Y") && !string.equalsIgnoreCase("Yes")) {
                System.exit(0);
            }
        }
        catch (KrbException krbException) {
            System.err.println("Error occured while deleting the entry. Deletion failed.");
            krbException.printStackTrace();
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("Error occured while deleting the entry.  Deletion failed.");
            iOException.printStackTrace();
            System.exit(-1);
        }
        this.table.deleteEntry(principalName);
        try {
            this.table.save();
        }
        catch (IOException iOException) {
            System.err.println("Error occurs while saving the keytab.Deletion fails.");
            iOException.printStackTrace();
            System.exit(-1);
        }
        System.out.println("Done!");
    }

    void printHelp() {
        System.out.println("\nUsage: ktab <options>");
        System.out.println("available options to Ktab:");
        System.out.println("-l\t\t\t\tlist the keytab name and entries");
        System.out.println("-a <principal name> (<password>)add an entry to the keytab");
        System.out.println("-d <principal name>\t\tdelete an entry from the keytab");
        System.out.println("-k <keytab name>\t\tspecify keytab name and  path with prefix FILE:");
    }
}

