/*
 * Decompiled with CFR 0.152.
 */
package org.javagalician.java6.util.spi;

import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import java.util.spi.TimeZoneNameProvider;
import org.javagalician.java6.constants.Locales;

public final class GalicianTimeZoneNameProvider
extends TimeZoneNameProvider {
    @Override
    public String getDisplayName(String ID, boolean daylight, int style, Locale locale) {
        if (ID == null) {
            throw new NullPointerException();
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        if (!GalicianTimeZoneNameProvider.isStyleValid(style)) {
            throw new IllegalArgumentException("Style \"" + style + "\" is not valid");
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            int i;
            DateFormatSymbols symbols = DateFormatSymbols.getInstance(Locales.GALICIAN_ES);
            String[][] zoneStrings = symbols.getZoneStrings();
            for (i = 0; i < zoneStrings.length; ++i) {
                if (!ID.equalsIgnoreCase(zoneStrings[i][0])) continue;
                switch (style) {
                    case 1: {
                        return daylight ? zoneStrings[i][3] : zoneStrings[i][1];
                    }
                    case 0: {
                        return daylight ? zoneStrings[i][4] : zoneStrings[i][2];
                    }
                }
            }
            if (!daylight) {
                for (i = 0; i < zoneStrings.length; ++i) {
                    if (!ID.equalsIgnoreCase(zoneStrings[i][2])) continue;
                    switch (style) {
                        case 1: {
                            return daylight ? zoneStrings[i][3] : zoneStrings[i][1];
                        }
                        case 0: {
                            return daylight ? zoneStrings[i][4] : zoneStrings[i][2];
                        }
                    }
                }
            } else {
                for (i = 0; i < zoneStrings.length; ++i) {
                    if (!ID.equalsIgnoreCase(zoneStrings[i][4])) continue;
                    switch (style) {
                        case 1: {
                            return daylight ? zoneStrings[i][3] : zoneStrings[i][1];
                        }
                        case 0: {
                            return daylight ? zoneStrings[i][4] : zoneStrings[i][2];
                        }
                    }
                }
            }
            TimeZone timeZone = TimeZone.getTimeZone(ID);
            return timeZone.getDisplayName(new Locale("en", "US"));
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    private static boolean isStyleValid(int style) {
        return style == 0 || style == 1;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return Locales.GALICIAN_ARRAY;
    }
}

