/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.BrowserLaunchingFactory;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import java.util.List;
import net.sf.wraplog.AbstractLogger;
import net.sf.wraplog.Logger;

public class BrowserLauncher {
    private final IBrowserLaunching launching;
    private AbstractLogger logger;
    static /* synthetic */ Class class$edu$stanford$ejalbert$BrowserLauncher;

    public BrowserLauncher(AbstractLogger logger) throws BrowserLaunchingInitializingException, UnsupportedOperatingSystemException {
        this.launching = this.initBrowserLauncher(logger);
    }

    public AbstractLogger getLogger() {
        return this.logger;
    }

    public List getBrowserList() {
        return this.launching.getBrowserList();
    }

    private IBrowserLaunching initBrowserLauncher(AbstractLogger logger) throws UnsupportedOperatingSystemException, BrowserLaunchingInitializingException {
        if (logger == null) {
            logger = Logger.getLogger(class$edu$stanford$ejalbert$BrowserLauncher == null ? (class$edu$stanford$ejalbert$BrowserLauncher = BrowserLauncher.class$("edu.stanford.ejalbert.BrowserLauncher")) : class$edu$stanford$ejalbert$BrowserLauncher);
            logger.setLevel(3);
        }
        this.logger = logger;
        IBrowserLaunching launching = BrowserLaunchingFactory.createSystemBrowserLaunching(logger);
        launching.initialize();
        return launching;
    }

    public void openURLinBrowser(String urlString) throws BrowserLaunchingInitializingException, BrowserLaunchingExecutionException, UnsupportedOperatingSystemException {
        this.launching.openUrl(urlString);
    }

    public void openURLinBrowser(String browser, String urlString) throws BrowserLaunchingInitializingException, BrowserLaunchingExecutionException, UnsupportedOperatingSystemException {
        this.launching.openUrl(browser, urlString);
    }

    public static void openURL(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        BrowserLauncher launcher = new BrowserLauncher(null);
        launcher.openURLinBrowser(urlString);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java -jar BrowserLauncher.jar url_value");
        } else {
            try {
                BrowserLauncher launcher = new BrowserLauncher(null);
                launcher.openURLinBrowser(args[0]);
            }
            catch (BrowserLaunchingInitializingException ex) {
                ex.printStackTrace();
            }
            catch (BrowserLaunchingExecutionException ex) {
                ex.printStackTrace();
            }
            catch (UnsupportedOperatingSystemException ex) {
                ex.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

