/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AuthDialog;
import biz.papercut.pcng.client.uit.ClientAccountCache;
import biz.papercut.pcng.client.uit.MSWindowsUtils;
import biz.papercut.pcng.client.uit.PrintJobDetailsPanel;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.common.AccountCommentOption;
import biz.papercut.pcng.common.AccountInvoiceOption;
import biz.papercut.pcng.common.ChargeRate;
import biz.papercut.pcng.common.ChargeToAccountType;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.common.ClientJobUpdateResponse;
import biz.papercut.pcng.common.ClientPopupInfo;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.UserDetails;
import biz.papercut.pcng.util.Formatter;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.CheckBoxList;
import biz.papercut.pcng.util.swing.DialogBannerPanel;
import biz.papercut.pcng.util.swing.DialogUtils;
import biz.papercut.pcng.util.swing.SwingWorker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagerModeDialog
extends JDialog {
    private static final Log logger = LogFactory.getLog(ManagerModeDialog.class);
    private final ServerConnection _serverConnection;
    private final ClientPrintJob _printJob;
    private final UserClientConfig _clientConfig;
    private boolean _hasCurrentUserNameBeenTested = false;
    private String _verifiedUserName = null;
    private int _jobsInQueue = 0;
    private PrintJobDetailsPanel _printJobDetailsPanel;
    private JLabel _userNameLabel;
    private JTextField _userNameText;
    private JButton _verifyUserButton;
    private JLabel _userDetailsText;
    private JComboBox _accountListCombo;
    private JTextField _accountCodeText;
    private JTextField _adjustmentPerPage;
    private JTextField _adjustmentPerJob;
    private JTextField _adjustmentPerCopy;
    private CheckBoxList _adjustmentList;
    private JTextField _commentsText;
    private JCheckBox _applyToAllInQueue;
    private JButton _printButton;
    private JButton _cancelButton;
    private final Timer _updateJobInfoTimer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ManagerModeDialog.this.fetchUpdatedJobInfo();
        }
    });
    private final Timer _updateJobCountTimer = new Timer(2000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ManagerModeDialog.this.fetchUpdatedJobCount();
        }
    });

    public ManagerModeDialog(JFrame owner, UserClientConfig clientConfig, ServerConnection serverConnection, ClientPrintJob printJob) {
        super((Frame)owner, true);
        logger.debug((Object)("Displaying manager mode popup - Job: " + printJob));
        DialogUtils.setAlwaysOnTop((Window)this, (boolean)true);
        this.toFront();
        this._serverConnection = serverConnection;
        this._printJob = printJob;
        this._clientConfig = clientConfig;
        this.layoutComponents();
        this.pack();
        this.setTitle(Messages.getString(this.getClass(), (String)"SelectAccount.title", (String[])new String[0]));
        this.getRootPane().setDefaultButton(this._printButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ManagerModeDialog.this.cancelButtonPressed();
            }
        });
        final int minWidth = (int)this.getSize().getWidth();
        final int minHeight = (int)this.getSize().getHeight();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ManagerModeDialog.this.setSize(new Dimension(Math.max(minWidth, ManagerModeDialog.this.getWidth()), minHeight));
            }
        });
        this.setSize((int)((double)minWidth * 1.2), (int)((double)minHeight * 1.0));
        this.setLocationRelativeTo(null);
        this._updateJobCountTimer.start();
        if (this._printJob.isPreNotification()) {
            this._updateJobInfoTimer.start();
        }
        MSWindowsUtils.addWindowListenerToBringWindowToFrontOnOpen(this);
        DialogUtils.forceRepaintAfterOpened((Window)this);
        this._userNameText.requestFocus();
        this._userDetailsText.setPreferredSize(new Dimension(this._userNameLabel.getWidth(), this._userNameLabel.getHeight()));
        Font f = this._userDetailsText.getFont();
        this._userDetailsText.setFont(f.deriveFont(f.getStyle() ^ 1));
    }

    private void layoutComponents() {
        MigLayout layout = new MigLayout("insets panel, fill");
        this.setLayout((LayoutManager)layout);
        DialogBannerPanel banner = UserClientUtils.getStandardDialogBanner(ManagerModeDialog.format("title", new String[0]), ManagerModeDialog.format("description", new String[0]), this._clientConfig.getServerGlobalConfig());
        this.add((Component)banner, "north");
        this._printJobDetailsPanel = new PrintJobDetailsPanel();
        this._printJobDetailsPanel.displayJobDetails(this._printJob);
        this.add((Component)this._printJobDetailsPanel, "growx, wrap");
        this.add((Component)this.buildUserPanel(), "growx, wrap");
        this.add((Component)this.buildAccountPanel(), "growx, wrap");
        this.add((Component)this.buildAdjustmentsPanel(), "growx, wrap");
        this.add((Component)this.buildOptionsPanel(), "growx, wrap");
        this._applyToAllInQueue = new JCheckBox();
        this._applyToAllInQueue.setText(Messages.getString(this.getClass(), (String)"SelectAccount.apply-to-all-in-queue", (String[])new String[]{"1"}));
        this.add((Component)this._applyToAllInQueue, "split, gaptop 5, growx");
        this._printButton = new JButton(ManagerModeDialog.format("print", new String[0]));
        this.add((Component)this._printButton, "split, gaptop 5, tag ok");
        this._printButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManagerModeDialog.this.printButtonPressed();
            }
        });
        this._cancelButton = new JButton(ManagerModeDialog.format("cancel", new String[0]));
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManagerModeDialog.this.cancelButtonPressed();
            }
        });
        this.add((Component)this._cancelButton, "gaptop 5, tag cancel");
    }

    private JPanel buildUserPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder("1. " + ManagerModeDialog.format("step-user", new String[0])));
        MigLayout layout = new MigLayout("fillx", "[grow 0, shrink 0, 110lp, right][grow 0.6][grow 0]");
        p.setLayout((LayoutManager)layout);
        this._userNameLabel = new JLabel(ManagerModeDialog.format("username-or-id", new String[0]));
        p.add((Component)this._userNameLabel, "");
        this._userNameText = new JTextField("");
        p.add((Component)this._userNameText, "growx");
        this._verifyUserButton = new JButton(ManagerModeDialog.format("verify-user", new String[0]));
        p.add((Component)this._verifyUserButton, "wrap");
        p.add((Component)new JLabel(""), "");
        this._userDetailsText = new JLabel("");
        p.add((Component)this._userDetailsText, "span, height pref!, growx, width 100px::");
        this._userNameText.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ManagerModeDialog.this._verifiedUserName = null;
                ManagerModeDialog.this._hasCurrentUserNameBeenTested = false;
                ManagerModeDialog.this._verifyUserButton.setEnabled(ManagerModeDialog.this._userNameText.getText().trim().length() > 0);
                ManagerModeDialog.this._userDetailsText.setText("");
            }

            public void removeUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }

            public void changedUpdate(DocumentEvent e) {
                this.insertUpdate(e);
            }
        });
        this._userNameText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!ManagerModeDialog.this._hasCurrentUserNameBeenTested && ManagerModeDialog.this._userNameText.getText().trim().length() > 0) {
                    ManagerModeDialog.this.verifyUserPressed();
                }
            }
        });
        this._userNameText.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 10 && !ManagerModeDialog.this._hasCurrentUserNameBeenTested && ManagerModeDialog.this._userNameText.getText().trim().length() > 0) {
                    ManagerModeDialog.this.verifyUserPressed();
                }
            }
        });
        this._verifyUserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManagerModeDialog.this.verifyUserPressed();
            }
        });
        this._verifyUserButton.setEnabled(false);
        return p;
    }

    private JPanel buildAccountPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder("2. " + ManagerModeDialog.format("step-account", new String[0])));
        MigLayout layout = new MigLayout("fillx", "[110lp, right][grow]");
        p.setLayout((LayoutManager)layout);
        p.add((Component)new JLabel(ManagerModeDialog.format("select-account", new String[0])), "");
        this._accountListCombo = new JComboBox();
        this._accountListCombo.setEnabled(false);
        p.add((Component)this._accountListCombo, "growx, wrap");
        p.add((Component)new JLabel(ManagerModeDialog.format("account-pin-code", new String[0])), "");
        this._accountCodeText = new JTextField();
        p.add((Component)this._accountCodeText, "width 120lp, wrap");
        this.loadChargeRates();
        this.loadAccountList("");
        this._accountListCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManagerModeDialog.this._accountCodeText.setEnabled(ManagerModeDialog.this._accountListCombo.getSelectedIndex() == 0);
            }
        });
        return p;
    }

    private JPanel buildAdjustmentsPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder("3. " + ManagerModeDialog.format("step-adjustments", new String[0])));
        MigLayout layout = new MigLayout("fillx", "[110lp, right][][grow][][grow][][grow]");
        p.setLayout((LayoutManager)layout);
        p.add((Component)new JLabel(ManagerModeDialog.format("predefined-adjustments", new String[0])), "aligny top, gaptop 4px");
        this._adjustmentList = new CheckBoxList();
        this._adjustmentList.setVisibleRowCount(4);
        JScrollPane scrollPane = new JScrollPane((Component)this._adjustmentList);
        p.add((Component)scrollPane, "span 6, growx, growy, wrap");
        p.add((Component)new JLabel(ManagerModeDialog.format("custom-adjustments", new String[0])), "");
        this._adjustmentPerPage = new JTextField(Formatter.formatNumber((double)0.0, (int)2, null));
        this._adjustmentPerPage.setHorizontalAlignment(4);
        p.add((Component)this._adjustmentPerPage, "width 70lp");
        p.add((Component)new JLabel(ManagerModeDialog.format("adjust-per-page", new String[0])), "");
        this._adjustmentPerCopy = new JTextField(Formatter.formatNumber((double)0.0, (int)2, null));
        this._adjustmentPerCopy.setHorizontalAlignment(4);
        p.add((Component)this._adjustmentPerCopy, "width 70lp");
        p.add((Component)new JLabel(ManagerModeDialog.format("adjust-per-copy", new String[0])), "");
        this._adjustmentPerJob = new JTextField(Formatter.formatNumber((double)0.0, (int)2, null));
        this._adjustmentPerJob.setHorizontalAlignment(4);
        p.add((Component)this._adjustmentPerJob, "width 70lp");
        p.add((Component)new JLabel(ManagerModeDialog.format("adjust-per-job", new String[0])), "wrap");
        return p;
    }

    private JPanel buildOptionsPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder("4. " + ManagerModeDialog.format("step-options", new String[0])));
        MigLayout layout = new MigLayout("fillx");
        p.setLayout((LayoutManager)layout);
        this._commentsText = new JTextField("");
        p.add((Component)this._commentsText, "growx");
        return p;
    }

    private void loadAccountList(final String username) {
        this._accountListCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{Messages.getString(this.getClass(), (String)"SelectAccount.fetching-accounts", (String[])new String[0])}));
        SwingWorker<Object> worker = new SwingWorker<Object>(){
            private volatile List<ClientAccount> _accounts;

            public Object construct() {
                this._accounts = new ArrayList<ClientAccount>(ClientAccountCache.getInstance().getUserAccounts(ManagerModeDialog.this._printJob, username, ManagerModeDialog.this));
                Iterator<ClientAccount> iterator = this._accounts.iterator();
                while (iterator.hasNext()) {
                    ClientAccount acct = iterator.next();
                    if (!acct.isDisabled()) continue;
                    iterator.remove();
                }
                return null;
            }

            public void finished() {
                ClientAccount personal = new ClientAccount(-1L);
                personal.setParentName(ManagerModeDialog.format("users-personal-account", new String[0]));
                personal.setComments(AccountCommentOption.COMMENT_OPTIONAL);
                personal.setInvoicing(AccountInvoiceOption.NEVER_INVOICE);
                this._accounts.add(0, personal);
                DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(this._accounts.toArray());
                model.insertElementAt(ManagerModeDialog.format("select-account-from-list", new String[0]), 0);
                ManagerModeDialog.this._accountListCombo.setModel(model);
                if (this._accounts.size() == 1) {
                    ManagerModeDialog.this._accountListCombo.setSelectedIndex(1);
                } else {
                    ManagerModeDialog.this._accountListCombo.setSelectedIndex(0);
                    String defaultSelectedAccount = ManagerModeDialog.this._clientConfig.getDefaultSelectedAccount();
                    if (StringUtils.isNotBlank((String)defaultSelectedAccount)) {
                        for (ClientAccount account : this._accounts) {
                            if (!account.getDisplayName().equalsIgnoreCase(defaultSelectedAccount)) continue;
                            ManagerModeDialog.this._accountListCombo.setSelectedItem(account);
                        }
                    }
                }
                ManagerModeDialog.this._accountListCombo.setEnabled(true);
                Dimension preferedSize = ManagerModeDialog.this.getPreferredSize();
                Dimension size = ManagerModeDialog.this.getSize();
                if (size.getWidth() < preferedSize.getWidth()) {
                    ManagerModeDialog.this.pack();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Resized to fit large account names. Before: " + size + ", After: " + ManagerModeDialog.this.getSize()));
                    }
                }
            }
        };
        worker.start();
    }

    private void loadChargeRates() {
        SwingWorker<List<ChargeRate>> worker = new SwingWorker<List<ChargeRate>>(){

            public List<ChargeRate> construct() {
                return ManagerModeDialog.this._serverConnection.getChargeRates(ManagerModeDialog.this._printJob);
            }

            public void finished() {
                List chargeRates = (List)this.getValue();
                if (chargeRates.size() == 0) {
                    ManagerModeDialog.this._adjustmentList.setEmptyMessage(ManagerModeDialog.format("no-standard-rates-defined", new String[0]));
                } else {
                    Object[] l = chargeRates.toArray(new Object[chargeRates.size()]);
                    ManagerModeDialog.this._adjustmentList.setListData(l);
                }
            }
        };
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyUserPressed() {
        this._verifiedUserName = null;
        this._hasCurrentUserNameBeenTested = true;
        String userNameOrId = StringUtils.trimToEmpty((String)this._userNameText.getText());
        if (StringUtils.isBlank((String)userNameOrId)) {
            this.displayErrorDialog(ManagerModeDialog.format("error-no-username", new String[0]));
            this._userNameText.requestFocus();
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            UserDetails user = this._serverConnection.getUserDetails(userNameOrId, true);
            if (user == null) {
                String txt = ManagerModeDialog.format("unknown-user", userNameOrId);
                this._userDetailsText.setText(txt);
                this._userDetailsText.setForeground(Color.red);
                this._userNameText.requestFocus();
                this._userNameText.setSelectionStart(0);
                this._userNameText.setSelectionEnd(this._userDetailsText.getText().length());
            } else {
                String details = StringUtils.isNotBlank((String)user.getFullName()) ? ManagerModeDialog.format("verified", new String[0]) + " - " + user.getFullName() + " (" + user.getUserName() + ")" : ManagerModeDialog.format("verified", new String[0]) + " - " + user.getUserName();
                this._userDetailsText.setText(details);
                this._userDetailsText.setForeground(new Color(32320));
                this._verifiedUserName = user.getUserName();
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void printButtonPressed() {
        ClientPopupInfo popupInfo = new ClientPopupInfo();
        popupInfo.setChargeToAccountType(ChargeToAccountType.ManagerPrint);
        if (StringUtils.isBlank((String)this._verifiedUserName)) {
            this.displayErrorDialog(ManagerModeDialog.format("err-no-valid-user-entered", new String[0]));
            this._userNameText.requestFocus();
            return;
        }
        popupInfo.setUserName(this._verifiedUserName);
        if (this._accountListCombo.getSelectedIndex() > 0) {
            ClientAccount acct = (ClientAccount)this._accountListCombo.getSelectedItem();
            popupInfo.setAccountId(acct.getAccountId());
        } else {
            String accountPinCode = StringUtils.trimToNull((String)this._accountCodeText.getText());
            if (accountPinCode == null) {
                this.displayErrorDialog(ManagerModeDialog.format("err-no-account-selected", new String[0]));
                return;
            }
            popupInfo.setAccountPin(accountPinCode);
        }
        Object[] rateObjs = this._adjustmentList.getSelectedValues();
        ArrayList<ChargeRate> rates = new ArrayList<ChargeRate>();
        for (Object o : rateObjs) {
            rates.add((ChargeRate)o);
        }
        popupInfo.setChargeRates(rates);
        Double d = this.parseAdjustmentAmount(this._adjustmentPerPage.getText());
        if (d == null) {
            this.displayErrorDialog(ManagerModeDialog.format("err-invalid-per-page", new String[0]));
            this._adjustmentPerPage.requestFocus();
            return;
        }
        if (d != 0.0) {
            rates.add(new ChargeRate("Custom", d.doubleValue(), Formatter.formatNumber((double)d, (int)2, null), ChargeRate.ChargeRateType.PerPage));
        }
        if ((d = this.parseAdjustmentAmount(this._adjustmentPerCopy.getText())) == null) {
            this.displayErrorDialog(ManagerModeDialog.format("err-invalid-per-copy", new String[0]));
            this._adjustmentPerCopy.requestFocus();
            return;
        }
        if (d != 0.0) {
            rates.add(new ChargeRate("Custom", d.doubleValue(), Formatter.formatNumber((double)d, (int)2, null), ChargeRate.ChargeRateType.PerCopy));
        }
        if ((d = this.parseAdjustmentAmount(this._adjustmentPerJob.getText())) == null) {
            this.displayErrorDialog(ManagerModeDialog.format("err-invalid-per-job", new String[0]));
            this._adjustmentPerJob.requestFocus();
            return;
        }
        if (d != 0.0) {
            rates.add(new ChargeRate("Custom", d.doubleValue(), Formatter.formatNumber((double)d, (int)2, null), ChargeRate.ChargeRateType.PerJob));
        }
        popupInfo.setChargeToAccountType(ChargeToAccountType.ManagerPrint);
        popupInfo.setComment(this._commentsText.getText());
        boolean applyToAll = this._applyToAllInQueue.isSelected();
        ClientJobUpdateResponse status = applyToAll ? this._serverConnection.updateAllPendingPrintJobs(this._printJob, false, popupInfo) : this._serverConnection.updatePendingPrintJob(this._printJob, false, popupInfo);
        if (status.isSuccess()) {
            this.closeAccountDialog();
        } else {
            this.displayErrorDialog(status.getErrorMessage());
            if (!status.isAllowRetry()) {
                this.closeAccountDialog();
            }
        }
    }

    private Double parseAdjustmentAmount(String text) {
        if ((text = StringUtils.trimToNull((String)text)) == null) {
            return 0.0;
        }
        text = text.replace("$", "");
        text = text.replace("\u00a3", "");
        text = text.replace("\u00a4", "");
        text = text.replace("\u00a5", "");
        text = text.replace("\u20ac", "");
        if ((text = text.replace("\u20a3", "")).contains("%")) {
            logger.debug((Object)("Invalid adjustment amount: " + text));
            return null;
        }
        try {
            return Formatter.parseDouble((String)text, null);
        }
        catch (NumberFormatException nfe) {
            logger.debug((Object)("Invalid adjustment amount: " + nfe));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelButtonPressed() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            boolean applyToAll = this._applyToAllInQueue.isSelected();
            this._serverConnection.cancelPendingPrintJob(this._printJob, applyToAll);
            this.closeAccountDialog();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void closeAccountDialog() {
        this._updateJobCountTimer.stop();
        this._updateJobInfoTimer.stop();
        this.setVisible(false);
    }

    protected void fetchUpdatedJobCount() {
        this._updateJobCountTimer.stop();
        SwingWorker<Object> worker = new SwingWorker<Object>(){

            public Object construct() {
                int newJobCount = ManagerModeDialog.this._serverConnection.getPendingPrintJobCount();
                if (newJobCount != ManagerModeDialog.this._jobsInQueue) {
                    ManagerModeDialog.this._updateJobCountTimer.setDelay(4000);
                    ManagerModeDialog.this._updateJobCountTimer.setInitialDelay(4000);
                    ManagerModeDialog.this._jobsInQueue = newJobCount;
                }
                return null;
            }

            public void finished() {
                String jobs = String.valueOf(ManagerModeDialog.this._jobsInQueue);
                ManagerModeDialog.this._applyToAllInQueue.setText(Messages.getString(((Object)((Object)this)).getClass(), (String)"SelectAccount.apply-to-all-in-queue", (String[])new String[]{jobs}));
                ManagerModeDialog.this._updateJobCountTimer.start();
                int newDelay = Math.min(ManagerModeDialog.this._updateJobCountTimer.getDelay() + 2000, 20000);
                ManagerModeDialog.this._updateJobCountTimer.setDelay(newDelay);
                ManagerModeDialog.this._updateJobCountTimer.setInitialDelay(newDelay);
            }
        };
        worker.start();
    }

    private void fetchUpdatedJobInfo() {
        this._updateJobInfoTimer.stop();
        SwingWorker<Object> worker = new SwingWorker<Object>(){

            public Object construct() {
                ManagerModeDialog.this._serverConnection.getUpdatedPrintJobInfo(ManagerModeDialog.this._printJob);
                return null;
            }

            public void finished() {
                ManagerModeDialog.this._printJobDetailsPanel.displayJobDetails(ManagerModeDialog.this._printJob);
                if (ManagerModeDialog.this._printJob.isPreNotification()) {
                    int newDelay = Math.min(ManagerModeDialog.this._updateJobInfoTimer.getDelay() + 1000, 10000);
                    ManagerModeDialog.this._updateJobInfoTimer.setInitialDelay(newDelay);
                    ManagerModeDialog.this._updateJobInfoTimer.setDelay(newDelay);
                    ManagerModeDialog.this._updateJobInfoTimer.start();
                }
            }
        };
        worker.start();
    }

    private void displayErrorDialog(String msg) {
        DialogUtils.showInformationMessageDialog((Component)this, (String)Messages.getString(this.getClass(), (String)"SelectAccount.error", (String[])new String[0]), (String)msg);
    }

    public boolean selectionAppliedToAllJobs() {
        return this._applyToAllInQueue.isSelected();
    }

    private static String format(String key, String ... args) {
        String fullKey = "ManagerModeDialog." + key;
        return Messages.getString(AuthDialog.class, (String)fullKey, (String[])args);
    }
}

