/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.BasePrintDialog;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogResponse;
import biz.papercut.pcng.util.BrowserLinkUtils;
import biz.papercut.pcng.util.Messages;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomMessagePrintDialog
extends BasePrintDialog {
    private static final Log logger = LogFactory.getLog(CustomMessagePrintDialog.class);
    private final JButton[] _buttons;
    protected JEditorPane _message;
    protected final ServerConnection _conn;
    protected final MessageDialogRequest _request;
    protected final ClientPrintJob _job;

    public static CustomMessagePrintDialog construct(JFrame owner, MessageDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        CustomMessagePrintDialog d = new CustomMessagePrintDialog(owner, request, job, conn, config);
        d.initializeMessageDialog();
        return d;
    }

    protected CustomMessagePrintDialog(JFrame owner, MessageDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        super(owner, config);
        this._request = request;
        this._conn = conn;
        this._job = job;
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JButton pressed = (JButton)e.getSource();
                logger.debug((Object)("Button pressed: " + pressed.getText()));
                for (int i = 0; i < CustomMessagePrintDialog.this._buttons.length; ++i) {
                    String name;
                    if (pressed != CustomMessagePrintDialog.this._buttons[i] || !CustomMessagePrintDialog.this.handleButtonPress(name = (String)CustomMessagePrintDialog.this._request.getButtons().get(i))) continue;
                    CustomMessagePrintDialog.this.setVisible(false);
                }
            }
        };
        this._buttons = new JButton[request.getButtons().size()];
        for (int i = 0; i < this._buttons.length; ++i) {
            String buttonName = (String)request.getButtons().get(i);
            buttonName = this.translateButtonNameIfRequired(buttonName);
            this._buttons[i] = new JButton(buttonName);
            this._buttons[i].addActionListener(buttonListener);
        }
    }

    protected boolean handleButtonPress(String button) {
        this._conn.setClientDialogResponse(this._job.getJobId(), this._request.getUniqueID(), (ClientDialogResponse)new MessageDialogResponse(button));
        return true;
    }

    protected void initializeMessageDialog() {
        String dialogDesc;
        String dialogTitle = this._request.getDialogTitle();
        if (StringUtils.isBlank((String)dialogTitle)) {
            dialogTitle = Messages.getString(this.getClass(), (String)"SelectAccount.title", (String[])new String[0]);
        }
        if (StringUtils.isBlank((String)(dialogDesc = this._request.getDialogDescription()))) {
            dialogDesc = Messages.getString(this.getClass(), (String)"SelectAccount.description", (String[])new String[0]);
        }
        this.initializeBase(dialogTitle, dialogDesc, true, this._request.getHideJobDetails() ? BasePrintDialog.ShowPrintJobOptions.ShowNone : (this._job.isPreNotification() ? BasePrintDialog.ShowPrintJobOptions.ShowBasicOnly : BasePrintDialog.ShowPrintJobOptions.ShowAll));
        String htmlMessage = this.convertToHTMLIfRequired(this._request.getMessage());
        htmlMessage = this.expandVars(htmlMessage);
        this._message.setText(htmlMessage);
        this.displayJobDetails(this._job);
    }

    private String translateButtonNameIfRequired(String buttonName) {
        if (buttonName.equalsIgnoreCase("OK")) {
            return Messages.getString(this.getClass(), (String)"Dialog.ok", (String[])new String[0]);
        }
        if (buttonName.equalsIgnoreCase("PRINT")) {
            return Messages.getString(this.getClass(), (String)"Dialog.print", (String[])new String[0]);
        }
        if (buttonName.equalsIgnoreCase("CANCEL")) {
            return Messages.getString(this.getClass(), (String)"Dialog.cancel", (String[])new String[0]);
        }
        if (buttonName.equalsIgnoreCase("YES")) {
            return Messages.getString(this.getClass(), (String)"Dialog.yes", (String[])new String[0]);
        }
        if (buttonName.equalsIgnoreCase("NO")) {
            return Messages.getString(this.getClass(), (String)"Dialog.no", (String[])new String[0]);
        }
        return buttonName;
    }

    protected JPanel constructButtonPanel() {
        JPanel p = ButtonBarFactory.buildRightAlignedBar((JButton[])this._buttons);
        p.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        return p;
    }

    protected JPanel constructMainPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
        String html = this.convertToHTMLIfRequired(this._request.getMessage());
        html = this.expandVars(html);
        html = this.unwrapHTMLTag(html, "html");
        html = this.unwrapHTMLTag(html, "body");
        html = "<html><div style='width: 400px'>" + html + "</div></html>";
        JEditorPane jep = new JEditorPane("text/html", html);
        jep.setEditable(false);
        jep.setOpaque(false);
        jep.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jep.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hle) {
                String link;
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType()) && StringUtils.isNotBlank((String)(link = hle.getDescription()))) {
                    logger.debug((Object)("Opening link in browser: " + link));
                    BrowserLinkUtils.openBrowser((String)link);
                }
            }
        });
        this._message = jep;
        p.add((Component)this._message, "Center");
        return p;
    }

    protected JButton getDefaultButton() {
        if (this._buttons.length == 1) {
            return this._buttons[0];
        }
        return null;
    }

    protected boolean handleWindowClosing(WindowEvent e) {
        for (String buttonName : this._request.getButtons()) {
            if (!buttonName.equalsIgnoreCase("Cancel")) continue;
            this._conn.setClientDialogResponse(this._job.getJobId(), this._request.getUniqueID(), (ClientDialogResponse)new MessageDialogResponse(buttonName));
            return true;
        }
        return false;
    }

    private String convertToHTMLIfRequired(String message) {
        String msgLower = message.trim().toLowerCase();
        if (msgLower.startsWith("<html>") && msgLower.endsWith("</html>")) {
            return message;
        }
        String html = message;
        html = message.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\r", "").replace("\n", "<br/>");
        html = "<html>" + html + "</html>";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Converted message to HTML. Original: " + message + ", HTML: " + html));
        }
        return html;
    }

    private String expandVars(String message) {
        String pcServerVar = "%PC_SERVER%";
        if (message.contains("%PC_SERVER%")) {
            String serverConnName = this._conn.getConnectionName() + ":" + String.valueOf(this._conn.getConnectionPort());
            message = message.replaceAll("%PC_SERVER%", serverConnName);
        }
        return message;
    }

    private String unwrapHTMLTag(String html, String tagName) {
        html = html.trim();
        String lower = html.trim().toLowerCase();
        tagName = tagName.toLowerCase();
        String start = "<" + tagName + ">";
        String end = "</" + tagName + ">";
        if (lower.startsWith(start) && lower.endsWith(end)) {
            html = html.substring(start.length());
            html = html.substring(0, html.length() - end.length());
        }
        return html;
    }
}

