/*
 * Decompiled with CFR 0.152.
 */
package org.javagalician.java6.text.spi;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.spi.DateFormatProvider;
import java.util.Arrays;
import java.util.Locale;
import org.javagalician.java6.constants.Locales;

public final class GalicianDateFormatProvider
extends DateFormatProvider {
    private static final String PATTERN_DATE_SHORT = "d'/'MM'/'yy";
    private static final String PATTERN_DATE_MEDIUM = "dd'-'MMM'-'yyyy";
    private static final String PATTERN_DATE_LONG = "d 'de' MMMM 'de' yyyy";
    private static final String PATTERN_DATE_FULL = "EEEE d 'de' MMMM 'de' yyyy";
    private static final String PATTERN_TIME_SHORT = "H':'mm";
    private static final String PATTERN_TIME_MEDIUM = "H':'mm':'ss";
    private static final String PATTERN_TIME_LONG = "H':'mm':'ss z";
    private static final String PATTERN_TIME_FULL = "HH'H'mm'' z";

    @Override
    public DateFormat getDateInstance(int style, Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (!GalicianDateFormatProvider.isStyleValid(style)) {
            throw new IllegalArgumentException("Style \"" + style + "\" is not valid");
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            switch (style) {
                case 0: {
                    return new SimpleDateFormat(PATTERN_DATE_FULL, locale);
                }
                case 1: {
                    return new SimpleDateFormat(PATTERN_DATE_LONG, locale);
                }
                case 2: {
                    return new SimpleDateFormat(PATTERN_DATE_MEDIUM, locale);
                }
                case 3: {
                    return new SimpleDateFormat(PATTERN_DATE_SHORT, locale);
                }
            }
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    @Override
    public DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (!GalicianDateFormatProvider.isStyleValid(dateStyle)) {
            throw new IllegalArgumentException("Style \"" + dateStyle + "\" is not valid");
        }
        if (!GalicianDateFormatProvider.isStyleValid(timeStyle)) {
            throw new IllegalArgumentException("Style \"" + timeStyle + "\" is not valid");
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            StringBuffer pattern = new StringBuffer();
            switch (dateStyle) {
                case 0: {
                    pattern.append(PATTERN_DATE_FULL);
                    break;
                }
                case 1: {
                    pattern.append(PATTERN_DATE_LONG);
                    break;
                }
                case 2: {
                    pattern.append(PATTERN_DATE_MEDIUM);
                    break;
                }
                case 3: {
                    pattern.append(PATTERN_DATE_SHORT);
                }
            }
            pattern.append(" ");
            switch (timeStyle) {
                case 0: {
                    pattern.append(PATTERN_TIME_FULL);
                    break;
                }
                case 1: {
                    pattern.append(PATTERN_TIME_LONG);
                    break;
                }
                case 2: {
                    pattern.append(PATTERN_TIME_MEDIUM);
                    break;
                }
                case 3: {
                    pattern.append(PATTERN_TIME_SHORT);
                }
            }
            return new SimpleDateFormat(pattern.toString(), locale);
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    @Override
    public DateFormat getTimeInstance(int style, Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (!GalicianDateFormatProvider.isStyleValid(style)) {
            throw new IllegalArgumentException("Style \"" + style + "\" is not valid");
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            switch (style) {
                case 0: {
                    return new SimpleDateFormat(PATTERN_TIME_FULL, locale);
                }
                case 1: {
                    return new SimpleDateFormat(PATTERN_TIME_LONG, locale);
                }
                case 2: {
                    return new SimpleDateFormat(PATTERN_TIME_MEDIUM, locale);
                }
                case 3: {
                    return new SimpleDateFormat(PATTERN_TIME_SHORT, locale);
                }
            }
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    private static boolean isStyleValid(int style) {
        return style == 3 || style == 2 || style == 1 || style == 0;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return Locales.GALICIAN_ARRAY;
    }
}

