/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.common.ClientAction;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogRequestWithJobInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientController
extends Thread {
    private static final Log logger = LogFactory.getLog(ClientController.class);
    private static final int BALANCE_CHECK_WAIT_MS = 1000;
    private final ServerConnection _connection;
    private final UserClientConfig _config;
    private final Set<MessageListener> _msgListeners = new HashSet<MessageListener>(1);
    private final Set<PrintJobListener> _printJobListeners = new HashSet<PrintJobListener>(1);
    private final Set<BalanceUpdateListener> _balanceListeners = new HashSet<BalanceUpdateListener>(1);
    private final Set<AuthenticationEventListener> _authListeners = new HashSet<AuthenticationEventListener>(1);
    private final Set<DialogRequestListener> _dialogRequestListeners = new HashSet<DialogRequestListener>(1);

    public ClientController(ServerConnection connection, UserClientConfig clientConfig) {
        this._connection = connection;
        this._config = clientConfig;
        this.setDaemon(true);
    }

    public void addMessageListener(MessageListener listener) {
        this._msgListeners.add(listener);
    }

    public void addPrintJobListener(PrintJobListener listener) {
        this._printJobListeners.add(listener);
    }

    public void addDialogRequestListener(DialogRequestListener listener) {
        this._dialogRequestListeners.add(listener);
    }

    public void addBalanceListener(BalanceUpdateListener listener) {
        this._balanceListeners.add(listener);
    }

    public void addAuthenticationRequestListener(AuthenticationEventListener listener) {
        this._authListeners.add(listener);
    }

    @Override
    public void run() {
        Random rand = new Random();
        List<ClientAction> actions = null;
        while (true) {
            try {
                while (true) {
                    actions = this._connection.getPendingActions(this._config.getTimeoutSecs());
                    block14: for (ClientAction action : actions) {
                        switch (action) {
                            case UserMessages: {
                                this.sendMessagesToListeners(this._connection.getPendingMessages());
                                continue block14;
                            }
                            case PrintJobs: {
                                this.sendPrintJobsToListeners(this._connection.getPendingPrintJobs());
                                continue block14;
                            }
                            case BalanceUpdate: {
                                Thread.sleep(1000L);
                                this.sendBalanceToListeners(this._connection.getUserBalance(this._config.getDisplayUserName()));
                                continue block14;
                            }
                            case AuthenticationRequested: {
                                this.sendAuthenticationRequestToListeners();
                                continue block14;
                            }
                            case AuthenticationExpired: {
                                this.sendAuthenticationExpiredEventToListeners();
                                continue block14;
                            }
                            case DialogRequest: {
                                this.sendDialogRequestsToListeners(this._connection.getPendingClientDialogs());
                                continue block14;
                            }
                        }
                        logger.debug((Object)("Unknown action: " + action + "."));
                    }
                    if (actions.size() != 0) continue;
                    Thread.sleep(rand.nextInt(1000));
                }
            }
            catch (Throwable t) {
                logger.error((Object)"Error fetching client actions", t);
                try {
                    Thread.sleep(30000 + rand.nextInt(30000));
                }
                catch (InterruptedException e) {
                }
                continue;
            }
            break;
        }
    }

    private void sendMessagesToListeners(List<String> msgs) {
        if (msgs == null || msgs.size() == 0) {
            return;
        }
        for (MessageListener listener : this._msgListeners) {
            try {
                listener.newMessages(msgs, this._config);
            }
            catch (Throwable t) {
                logger.error((Object)("Error sending new messages to listener: " + listener + ". " + t.getMessage()), t);
            }
        }
    }

    private void sendPrintJobsToListeners(List<ClientPrintJob> printJobs) {
        if (printJobs == null || printJobs.size() == 0) {
            return;
        }
        for (PrintJobListener listener : this._printJobListeners) {
            try {
                listener.newPrintJobs(printJobs);
            }
            catch (Throwable t) {
                logger.error((Object)("Error sending new print jobs to listener: " + listener + ". " + t.getMessage()), t);
            }
        }
    }

    private void sendDialogRequestsToListeners(List<ClientDialogRequestWithJobInfo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (DialogRequestListener listener : this._dialogRequestListeners) {
            try {
                listener.newDialogRequests(list);
            }
            catch (Throwable t) {
                logger.error((Object)("Error sending new dialogs to listener: " + listener + ". " + t.getMessage()), t);
            }
        }
    }

    private void sendAuthenticationRequestToListeners() {
        for (AuthenticationEventListener listener : this._authListeners) {
            try {
                listener.newAuthenticationRequest();
            }
            catch (Throwable t) {
                logger.error((Object)("Error sending new auth request to listener: " + listener + ". " + t.getMessage()), t);
            }
        }
    }

    private void sendAuthenticationExpiredEventToListeners() {
        for (AuthenticationEventListener listener : this._authListeners) {
            try {
                listener.authenticationExpired();
            }
            catch (Throwable t) {
                logger.error((Object)("Error sending new auth expired listeners: " + listener + ". " + t.getMessage()), t);
            }
        }
    }

    private void sendBalanceToListeners(String balance) {
        for (BalanceUpdateListener listener : this._balanceListeners) {
            try {
                listener.newBalance(balance);
            }
            catch (Throwable t) {
                logger.error((Object)("Error sending new balance to listener: " + listener + ". " + t.getMessage()), t);
            }
        }
    }

    public static interface BalanceUpdateListener {
        public void newBalance(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DialogRequestListener {
        public void newDialogRequests(List<ClientDialogRequestWithJobInfo> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PrintJobListener {
        public void newPrintJobs(List<ClientPrintJob> var1);
    }

    public static interface AuthenticationEventListener {
        public void newAuthenticationRequest();

        public void authenticationExpired();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MessageListener {
        public void newMessages(List<String> var1, UserClientConfig var2);
    }
}

