/*
 * Decompiled with CFR 0.152.
 */
package org.javagalician.java6.text.spi;

import java.text.BreakIterator;
import java.text.spi.BreakIteratorProvider;
import java.util.Arrays;
import java.util.Locale;
import org.javagalician.java6.constants.Locales;

public final class GalicianBreakIteratorProvider
extends BreakIteratorProvider {
    @Override
    public BreakIterator getCharacterInstance(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            return BreakIterator.getCharacterInstance(Locales.CASTILIAN);
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    @Override
    public BreakIterator getLineInstance(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            return BreakIterator.getLineInstance(Locales.CASTILIAN);
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    @Override
    public BreakIterator getSentenceInstance(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            return BreakIterator.getSentenceInstance(Locales.CASTILIAN);
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    @Override
    public BreakIterator getWordInstance(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (Locales.GALICIAN_LIST.contains(locale)) {
            return BreakIterator.getWordInstance(Locales.CASTILIAN);
        }
        throw new IllegalArgumentException("Locale \"" + locale + "\" " + "is not one of the supported locales (" + Arrays.asList(Locales.GALICIAN_ARRAY) + ")");
    }

    @Override
    public Locale[] getAvailableLocales() {
        return Locales.GALICIAN_ARRAY;
    }
}

