/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.Checksum;
import biz.papercut.pcng.util.MessageReceiver;
import biz.papercut.pcng.util.ObjectUtils;
import biz.papercut.pcng.util.StopWatch;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class TaskStatus
implements MessageReceiver {
    private static final int MAX_MESSAGE_SIZE = 500000;
    private static int _currentTaskCounter = 0;
    private final StringBuffer _messageBuffer = new StringBuffer();
    private boolean _complete = false;
    private boolean _receiverFull = false;
    private final String _taskName;
    private final Date _startTime = new Date();
    private final String _taskID;
    private final boolean _outputTiming;
    private final StopWatch _stopWatch;

    public TaskStatus(String taskName, String taskID) {
        this._taskID = StringUtils.isBlank((String)taskID) ? TaskStatus.getUniqueTaskID() : taskID;
        this._taskName = taskName;
        this._outputTiming = StringUtils.isNotBlank((String)System.getProperty("papercut.debug.task-timing"));
        if (this._outputTiming) {
            this._stopWatch = new StopWatch(taskName, true, false);
            this._stopWatch.start();
        } else {
            this._stopWatch = null;
        }
    }

    public TaskStatus(String taskName) {
        this(taskName, null);
    }

    public TaskStatus() {
        this(null, null);
    }

    public static synchronized String getUniqueTaskID() {
        if (++_currentTaskCounter > 1000) {
            _currentTaskCounter = 0;
        }
        String idToHash = System.currentTimeMillis() + "-" + _currentTaskCounter;
        return Checksum.getMD5Sum(idToHash);
    }

    public void setMessage(String message) {
        this.appendStatusMessage(message);
    }

    public synchronized void appendStatusMessage(String message) {
        if (this._outputTiming) {
            this._stopWatch.split(message);
        }
        if (this._messageBuffer.length() < 500000) {
            this._messageBuffer.append(message).append("\r\n");
        } else {
            if (!this._receiverFull) {
                this._messageBuffer.append("Task status too long. Unable to display further status messages!\r\n");
            }
            this._receiverFull = true;
        }
    }

    public synchronized String getStatusMessage() {
        return this._messageBuffer.toString();
    }

    public synchronized boolean isComplete() {
        return this._complete;
    }

    public synchronized void setComplete(boolean complete) {
        if (this._outputTiming && complete) {
            this._stopWatch.stop();
            this._messageBuffer.append("\r\n").append("============== TIMING INFO ==============").append("\r\n");
            this._messageBuffer.append(this._stopWatch.toString()).append("\r\n");
        }
        this._complete = complete;
    }

    public String getTaskName() {
        return this._taskName;
    }

    public Date getStartTime() {
        return this._startTime;
    }

    public String getTaskID() {
        return this._taskID;
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder(this).append("id", (Object)this.getTaskID()).append("name", (Object)this.getTaskName()).toString();
    }
}

