/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.tuple.Pair;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateTimeUtils {
    private DateTimeUtils() {
    }

    public static Date getLastSecondOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c = DateUtils.truncate((Calendar)c, (int)5);
        c.add(5, 1);
        c.add(14, -1);
        date = c.getTime();
        return date;
    }

    public static Date truncateTime(Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    public static long millisBetween(Date later, Date earlier) {
        return later.getTime() - earlier.getTime();
    }

    public static int daysBetween(Date later, Date earlier) {
        return (int)(DateTimeUtils.millisBetween(later, earlier) / 86400000L);
    }

    public static int minutesBetween(Date later, Date earlier) {
        return (int)(DateTimeUtils.millisBetween(later, earlier) / 60000L);
    }

    public static int secondsBetween(Date later, Date earlier) {
        return (int)(DateTimeUtils.millisBetween(later, earlier) / 1000L);
    }

    public static Date addDays(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        return c.getTime();
    }

    public static Date addMonth(Date date, int months) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, months);
        return c.getTime();
    }

    public static Date addYear(Date date, int years) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, years);
        return c.getTime();
    }

    public static Date addTimeToDate(Date date, Date time) {
        if (time == null) {
            return date;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Calendar timeCal = Calendar.getInstance();
        timeCal.setTime(time);
        c.set(11, timeCal.get(11));
        c.set(12, timeCal.get(12));
        c.set(13, timeCal.get(13));
        c.set(14, timeCal.get(14));
        return c.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        return DateTimeUtils.truncateTime(c.getTime());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        return DateTimeUtils.truncateTime(c.getTime());
    }

    public static Date getStartOfYesterday(Date date) {
        Date d = new Date(date.getTime());
        return DateTimeUtils.truncateTime(DateTimeUtils.addDays(d, -1));
    }

    public static Date getEndOfYesterday(Date date) {
        Date d = new Date(date.getTime());
        return DateTimeUtils.getLastSecondOfDay(DateTimeUtils.addDays(d, -1));
    }

    public static Date getStartOfLastFullWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, -7);
        c.set(7, 1);
        return DateTimeUtils.truncateTime(c.getTime());
    }

    public static Date getLastSecondOfLastFullWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 1);
        c.add(5, -1);
        return DateTimeUtils.getLastSecondOfDay(c.getTime());
    }

    public static Date getStartOfLastFullFortnight(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, -14);
        c.set(7, 1);
        return DateTimeUtils.truncateTime(c.getTime());
    }

    public static Date getLastSecondOfLastFullFortnight(Date date) {
        return DateTimeUtils.getLastSecondOfLastFullWeek(date);
    }

    public static Date getStartOfLastMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -1);
        c.set(5, 1);
        return DateTimeUtils.truncateTime(c.getTime());
    }

    public static Date getStartOfLastYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, -1);
        c.set(2, 0);
        c.set(5, 1);
        return DateTimeUtils.truncateTime(c.getTime());
    }

    public static Date getStartOfLastQuarter(Date date) {
        return DateTimeUtils.getLastQuarterDateRange(date).get0();
    }

    private static Pair<Date, Date> getLastQuarterDateRange(Date date) {
        Calendar cStartDate = Calendar.getInstance();
        Calendar cEndDate = Calendar.getInstance();
        cStartDate.setTime(date);
        cEndDate.setTime(date);
        int monthIndex = cStartDate.get(2);
        if (monthIndex == 0 || monthIndex == 1 || monthIndex == 2) {
            cStartDate.add(1, -1);
            cEndDate.add(1, -1);
            cStartDate.set(2, 9);
            cEndDate.set(2, 11);
        } else if (monthIndex == 3 || monthIndex == 4 || monthIndex == 5) {
            cStartDate.set(2, 0);
            cEndDate.set(2, 2);
        } else if (monthIndex == 6 || monthIndex == 7 || monthIndex == 8) {
            cStartDate.set(2, 3);
            cEndDate.set(2, 5);
        } else if (monthIndex == 9 || monthIndex == 10 || monthIndex == 11) {
            cStartDate.set(2, 6);
            cEndDate.set(2, 8);
        }
        cEndDate.set(5, 1);
        return Pair.from(DateTimeUtils.truncateTime(cStartDate.getTime()), DateTimeUtils.getLastSecondOfDay(DateTimeUtils.getLastDayOfMonth(cEndDate.getTime())));
    }

    public static Date getEndOfLastQuarter(Date date) {
        return DateTimeUtils.getLastQuarterDateRange(date).get1();
    }

    public static Date getEndOfLastYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, -1);
        c.set(2, 11);
        c.set(5, 31);
        return DateTimeUtils.getLastSecondOfDay(c.getTime());
    }

    public static boolean isFirstDayOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return DateTimeUtils.isFirstDayOfMonth(date) && c.get(2) == 0;
    }

    public static boolean isFirstDayOfAnnualQuarter(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        boolean isMonthOfQuarter = month == 0 || month == 3 || month == 6 || month == 9;
        return DateTimeUtils.isFirstDayOfMonth(date) && isMonthOfQuarter;
    }

    public static Date getLastSecondOfLastMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -1);
        c.set(5, c.getActualMaximum(5));
        return DateTimeUtils.getLastSecondOfDay(c.getTime());
    }

    public static boolean isFirstDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(7) == 1;
    }

    public static boolean isFirstDayOfFortnight(Date date) {
        if (DateTimeUtils.isFirstDayOfWeek(date)) {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            return c.get(3) % 2 == 0;
        }
        return false;
    }

    public static boolean isFirstDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5) == 1;
    }

    public static boolean isDayToRunMonthlyReports(Date date, int day) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5) == day;
    }

    public static Pair<Date, Date> getLastMonthPeriod(Date date, int dayOfMonth) {
        Date toDate;
        Date fromDate;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (dayOfMonth < 1 || dayOfMonth > 28) {
            dayOfMonth = 1;
        }
        if (dayOfMonth <= Calendar.getInstance().get(5)) {
            c.add(2, -1);
            c.set(5, dayOfMonth);
            fromDate = DateTimeUtils.truncateTime(c.getTime());
            c.setTime(date);
            c.set(5, dayOfMonth - 1);
            toDate = DateTimeUtils.getLastSecondOfDay(c.getTime());
        } else {
            c.add(2, -2);
            c.set(5, dayOfMonth);
            fromDate = DateTimeUtils.truncateTime(c.getTime());
            c.setTime(date);
            c.add(2, -1);
            c.set(5, dayOfMonth - 1);
            toDate = DateTimeUtils.getLastSecondOfDay(c.getTime());
        }
        Pair<Date, Date> period = Pair.from(fromDate, toDate);
        return period;
    }

    public static DateFormat getShortDateFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateFormat df = DateFormat.getDateInstance(3, locale);
        try {
            ((SimpleDateFormat)df).applyPattern("d MMM");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return df;
    }

    public static SortedSet<Date> csvToSet(String dateCSV) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)dateCSV)) {
            throw new IllegalArgumentException("CSV date input was blank");
        }
        TreeSet<Date> dates = new TreeSet<Date>();
        Pattern full = Pattern.compile("^(\\d{4})-(\\d{1,2})-(\\d{1,2})$");
        Pattern partialMonthAndDayOnly = Pattern.compile("^(?:\\*{1,4}-)?(\\d{1,2})-(\\d{1,2})$");
        Pattern partialDayOnly = Pattern.compile("^(?:\\*{1,4}-\\*{1,2}-)?(\\d{1,2})$");
        boolean monthIsWildcard = false;
        boolean yearIsWildcard = false;
        try {
            for (String date : dateCSV.split(",")) {
                date = date.trim();
                Calendar c = Calendar.getInstance();
                int yVal = c.get(1);
                int mVal = c.get(2);
                int dVal = c.get(5);
                boolean hasMatched = false;
                Matcher m = full.matcher(date);
                if (m.matches()) {
                    yVal = Integer.valueOf(m.group(1));
                    mVal = Integer.valueOf(m.group(2)) - 1;
                    dVal = Integer.valueOf(m.group(3));
                    hasMatched = true;
                }
                if (!hasMatched && (m = partialMonthAndDayOnly.matcher(date)).matches()) {
                    mVal = Integer.valueOf(m.group(1)) - 1;
                    dVal = Integer.valueOf(m.group(2));
                    hasMatched = true;
                    yearIsWildcard = true;
                }
                if (!hasMatched && (m = partialDayOnly.matcher(date)).matches()) {
                    dVal = Integer.valueOf(m.group(1));
                    hasMatched = true;
                    yearIsWildcard = true;
                    monthIsWildcard = true;
                }
                if (!hasMatched) {
                    throw new IllegalArgumentException("Invalid date format: " + date);
                }
                if (mVal < 0 || mVal > 11) {
                    throw new IllegalArgumentException("Invalid month: " + mVal);
                }
                if (dVal < 1 || dVal > 31) {
                    throw new IllegalArgumentException("Invalid day of month: " + dVal);
                }
                c.set(1, yVal);
                c.set(2, mVal);
                c.set(5, dVal);
                Date dateOnly = DateTimeUtils.truncateTime(c.getTime());
                if (dateOnly.before(DateTimeUtils.truncateTime(new Date()))) {
                    if (monthIsWildcard) {
                        c.add(2, 1);
                    } else if (yearIsWildcard) {
                        c.add(1, 1);
                    }
                }
                dates.add(DateTimeUtils.truncateTime(c.getTime()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse CSV date: " + e.getMessage(), e);
        }
        return dates;
    }

    public static boolean isToday(Date date) {
        Calendar today = Calendar.getInstance();
        Calendar d = Calendar.getInstance();
        d.setTime(date);
        return d.get(1) == today.get(1) && d.get(2) == today.get(2) && d.get(5) == today.get(5);
    }

    public static boolean includesToday(Set<Date> dates) {
        Calendar today = Calendar.getInstance();
        Calendar d = Calendar.getInstance();
        for (Date date : dates) {
            d.setTime(date);
            if (d.get(1) != today.get(1) || d.get(2) != today.get(2) || d.get(5) != today.get(5)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDateInFuture(Set<Date> dates) {
        if (dates == null) {
            return false;
        }
        long now = new Date().getTime();
        for (Date d : dates) {
            if (d.getTime() <= now) continue;
            return true;
        }
        return false;
    }

    public static Date min(Date a, Date b) {
        if (a == null || b == null) {
            return null;
        }
        if (a.getTime() < b.getTime()) {
            return a;
        }
        return b;
    }

    public static Date max(Date a, Date b) {
        if (a == null || b == null) {
            return null;
        }
        if (a.getTime() > b.getTime()) {
            return a;
        }
        return b;
    }
}

