/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common.release;

import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobReleaseStatus {
    private static final Log logger = LogFactory.getLog(JobReleaseStatus.class);
    private static final String FIELD_STATUS = "status";
    private StatusCode _status = StatusCode.Success;

    public JobReleaseStatus() {
    }

    public JobReleaseStatus(Hashtable<String, Object> data) {
        if (data == null || data.size() == 0) {
            return;
        }
        String valueStr = (String)data.get(FIELD_STATUS);
        if (StringUtils.isNotBlank((String)valueStr)) {
            StatusCode code = null;
            try {
                code = StatusCode.valueOf(valueStr);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (code == null) {
                logger.warn((Object)("Unknown job release status code: " + valueStr + ". Assume success."));
                this.setStatus(StatusCode.Success);
            } else {
                this.setStatus(code);
            }
        }
    }

    public Hashtable<String, Object> saveToHashtable() {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        data.put(FIELD_STATUS, this.getStatus().name());
        return data;
    }

    public StatusCode getStatus() {
        return this._status;
    }

    public void setStatus(StatusCode status) {
        if (status == null) {
            throw new IllegalArgumentException("Cannot have null status");
        }
        this._status = status;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this);
        tsb.append(FIELD_STATUS, (Object)this.getStatus());
        return tsb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusCode {
        Success,
        NotEnoughCredit,
        NoPotentialRedirectQueues;

    }
}

