/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.MessageReceiver;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DatabaseUtils {
    private static final Log logger = LogFactory.getLog(DatabaseUtils.class);

    private DatabaseUtils() {
    }

    public static Connection openConnection(String driverClass, String url, String username, @Nullable String password) throws SQLException {
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Unable to find database driver: " + driverClass);
        }
        logger.debug((Object)("Opening connection to database: " + url + ", driver: " + driverClass + ", with user:" + username));
        return DriverManager.getConnection(url, username, password);
    }

    public static int countRowsInTable(Connection conn, String table, String whereClause) throws SQLException {
        String sql = "select count(*) from " + table;
        if (StringUtils.isNotBlank((String)whereClause)) {
            sql = sql + " " + whereClause;
        }
        logger.debug((Object)("Counting table rows: " + sql));
        ResultSetHandler handler = new ResultSetHandler(){

            public Object handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt(1);
                }
                return 0;
            }
        };
        QueryRunner runner = new QueryRunner();
        Integer count = (Integer)runner.query(conn, sql, handler);
        return count;
    }

    public static int countRowsInTable(Connection conn, String table) throws SQLException {
        return DatabaseUtils.countRowsInTable(conn, table, null);
    }

    public static void runScript(Connection conn, String scriptPath, boolean ignoreSQLErrors) throws SQLException {
        DatabaseUtils.runScript(conn, scriptPath, ignoreSQLErrors, null);
    }

    public static void runScript(Connection conn, String scriptPath, boolean ignoreSQLErrors, MessageReceiver msgs) throws SQLException {
        if (msgs == null) {
            msgs = new MessageReceiver(){

                public void setMessage(String message) {
                    logger.debug((Object)message);
                }
            };
        }
        File dbScriptFile = new File(scriptPath);
        String dbScriptFileName = dbScriptFile.getAbsolutePath();
        if (!dbScriptFile.exists()) {
            throw new ApplicationException("Cannot find database script: " + dbScriptFileName);
        }
        msgs.setMessage("Running script: " + dbScriptFileName);
        BufferedReader reader = null;
        ArrayList<String> statements = new ArrayList<String>(100);
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(dbScriptFileName)));
            StringBuffer statement = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if (!StringUtils.isNotBlank((String)(line = line.trim())) || line.startsWith("--")) continue;
                if (line.endsWith(";")) {
                    statement.append(line.substring(0, line.length() - 1));
                    statements.add(statement.toString());
                    statement.setLength(0);
                    continue;
                }
                statement.append(line).append(' ');
            }
        }
        catch (IOException e) {
            try {
                throw new ApplicationException("Unable to read database creation script: " + dbScriptFileName);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        QueryRunner runner = new QueryRunner();
        for (String statement : statements) {
            msgs.setMessage("Running statement: " + statement);
            try {
                int affected = runner.update(conn, statement);
                if (affected <= 0) continue;
                msgs.setMessage("Rows affected: " + affected);
            }
            catch (SQLException e) {
                logger.error((Object)("Error running DB statement: " + statement + ". " + e.toString()));
                if (ignoreSQLErrors) continue;
                throw e;
            }
        }
    }

    public static boolean setAutoCommit(Connection conn, boolean autoCommit) {
        boolean origAutoCommit = true;
        try {
            origAutoCommit = conn.getAutoCommit();
        }
        catch (SQLException e) {
            logger.debug((Object)"Unable to determine auto-commit setting, assuming true.", (Throwable)e);
        }
        try {
            conn.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            logger.debug((Object)("Unable to set auto-commit to " + autoCommit), (Throwable)e);
        }
        return origAutoCommit;
    }

    public static boolean tableExists(DatabaseMetaData dbMetaData, String tableName) throws SQLException {
        return DatabaseUtils.tableExistsCaseSensitive(dbMetaData, tableName) || DatabaseUtils.tableExistsCaseSensitive(dbMetaData, tableName.toUpperCase(Locale.US)) || DatabaseUtils.tableExistsCaseSensitive(dbMetaData, tableName.toLowerCase(Locale.US));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tableExistsCaseSensitive(DatabaseMetaData dbMetaData, String tableName) throws SQLException {
        ResultSet rsTables = dbMetaData.getTables(null, null, tableName, null);
        try {
            boolean found;
            boolean bl = found = rsTables.next();
            return bl;
        }
        finally {
            DbUtils.closeQuietly((ResultSet)rsTables);
        }
    }

    public static void fillStatement(PreparedStatement stmt, Object[] params, int[] types) throws SQLException {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null) {
                stmt.setObject(i + 1, params[i]);
                continue;
            }
            if (types != null) {
                stmt.setNull(i + 1, types[i]);
                continue;
            }
            stmt.setNull(i + 1, 12);
        }
    }

    public static int deleteAllFromTable(Connection conn, String tableName) throws SQLException {
        QueryRunner runner = new QueryRunner();
        return runner.update(conn, "delete from " + tableName);
    }

    public static void commitIfAutoCommitDisabled(Connection conn) throws SQLException {
        if (!conn.getAutoCommit()) {
            conn.commit();
        }
    }

    public static void rollbackIfAutoCommitDisabled(Connection conn) throws SQLException {
        if (!conn.getAutoCommit()) {
            conn.rollback();
        }
    }

    public static void logAllSQLErrors(String msg, SQLException se) {
        logger.error((Object)(msg + " - " + se.getMessage()), (Throwable)se);
        int i = 1;
        while ((se = se.getNextException()) != null) {
            logger.error((Object)(msg + " (next exception " + i + ") - " + se.getMessage()), (Throwable)se);
            ++i;
        }
    }
}

