/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.io.IOUtils;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public final class PropertiesUtils {
    private PropertiesUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveUpdatedProperties(String existingFile, Properties props) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            props.store(baos, null);
        }
        finally {
            IOUtils.closeQuietly(baos);
        }
        BufferedReader reader = null;
        HashMap<String, String> encodedValues = new HashMap<String, String>(props.size());
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(baos.toByteArray()), Charsets.ISO_8859_1));
            while ((line = reader.readLine()) != null) {
                int equalsIndex;
                if (line.startsWith("#") || (equalsIndex = line.indexOf(61)) < 0) continue;
                String key = line.substring(0, equalsIndex);
                String string = line.substring(equalsIndex + 1);
                encodedValues.put(key, string);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        ArrayList<String> existingLines = new ArrayList<String>(props.size() * 2);
        try {
            String line;
            reader = new BufferedReader(new FileReader(existingFile));
            while ((line = reader.readLine()) != null) {
                existingLines.add(line);
            }
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(existingFile));
            for (String string : existingLines) {
                if (string.startsWith("#") || StringUtils.isBlank((String)string)) {
                    writer.println(string);
                    continue;
                }
                int equalsIndex = string.indexOf(61);
                if (equalsIndex < 0) {
                    writer.println(string);
                    continue;
                }
                String key = string.substring(0, equalsIndex);
                String newValue = (String)encodedValues.get(key);
                if (newValue == null) {
                    writer.println(string);
                    continue;
                }
                writer.print(key);
                writer.print('=');
                writer.println(newValue);
                encodedValues.remove(key);
            }
            for (Map.Entry entry : encodedValues.entrySet()) {
                writer.print((String)entry.getKey());
                writer.print('=');
                writer.println((String)entry.getValue());
            }
            writer.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
    }
}

