/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.logging.XMLFormatter;

public class SocketHandler
extends StreamHandler {
    private Socket sock;
    private String host;
    private int port;
    private String portProperty;

    private void configure() {
        LogManager logManager = LogManager.getLogManager();
        String string = this.getClass().getName();
        this.setLevel(logManager.getLevelProperty(string + ".level", Level.ALL));
        this.setFilter(logManager.getFilterProperty(string + ".filter", null));
        this.setFormatter(logManager.getFormatterProperty(string + ".formatter", new XMLFormatter()));
        try {
            this.setEncoding(logManager.getStringProperty(string + ".encoding", null));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.port = logManager.getIntProperty(string + ".port", 0);
        this.host = logManager.getStringProperty(string + ".host", null);
    }

    public SocketHandler() throws IOException {
        this.sealed = false;
        this.configure();
        try {
            this.connect();
        }
        catch (IOException iOException) {
            System.err.println("SocketHandler: connect failed to " + this.host + ":" + this.port);
            throw iOException;
        }
        this.sealed = true;
    }

    public SocketHandler(String string, int n) throws IOException {
        this.sealed = false;
        this.configure();
        this.sealed = true;
        this.port = n;
        this.host = string;
        this.connect();
    }

    private void connect() throws IOException {
        if (this.port == 0) {
            throw new IllegalArgumentException("Bad port: " + this.port);
        }
        if (this.host == null) {
            throw new IllegalArgumentException("Null host name: " + this.host);
        }
        this.sock = new Socket(this.host, this.port);
        OutputStream outputStream = this.sock.getOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        this.setOutputStream(bufferedOutputStream);
    }

    public synchronized void close() throws SecurityException {
        super.close();
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.sock = null;
    }

    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        super.publish(logRecord);
        this.flush();
    }
}

