/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit.accounts;

import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.util.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RecentListTableModel
extends AbstractTableModel {
    private Map<Long, ClientAccount> _allAccounts;
    private List<Long> _recentAccountIds;
    private List<ClientAccount> _recentAccountList;

    public RecentListTableModel() {
        ClientAccount ca = new ClientAccount(1L);
        ca.setDisabled(true);
        ca.setParentName(Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]));
        this._recentAccountList = new ArrayList<ClientAccount>(1);
        this._recentAccountList.add(ca);
    }

    public void loadData(List<ClientAccount> accounts, List<Long> recentAccountIds) {
        this._allAccounts = new HashMap<Long, ClientAccount>(accounts.size());
        for (ClientAccount a : accounts) {
            this._allAccounts.put(a.getAccountId(), a);
        }
        this._recentAccountIds = recentAccountIds;
        this.buildList();
        this.fireTableDataChanged();
    }

    private void buildList() {
        this._recentAccountList = new ArrayList<ClientAccount>(this._recentAccountIds.size());
        for (int i = 0; i < this._recentAccountIds.size(); ++i) {
            Long id = this._recentAccountIds.get(i);
            ClientAccount a = this._allAccounts.get(id);
            if (a == null) continue;
            this._recentAccountList.add(a);
        }
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_ACCOUNT", (String[])new String[0]);
        }
        if (column == 1) {
            return Messages.getString(this.getClass(), (String)"Common.HEADING_CODE", (String[])new String[0]);
        }
        throw new IllegalArgumentException("Unexpcted column index");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this._recentAccountList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (rowIndex >= this._recentAccountList.size()) {
                return "";
            }
            ClientAccount a = this._recentAccountList.get(rowIndex);
            if (a != null) {
                return a;
            }
            return "--error--";
        }
        if (columnIndex == 1) {
            ClientAccount a = this._recentAccountList.get(rowIndex);
            if (a != null) {
                return a.getFullPin();
            }
            return "";
        }
        throw new IllegalArgumentException("unexpected column index");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.getValueAt(0, columnIndex).getClass();
    }
}

